(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    250885,       7418]*)
(*NotebookOutlinePosition[    252091,       7457]*)
(*  CellTagsIndexPosition[    252047,       7453]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["\<\
Chapter 5
Higher-Order Approximations for Systems with Internal Resonances\
\>", "Title",
  TextAlignment->Left,
  TextJustification->0],

Cell[BoxData[
    \(Off[General::spell1]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell["5.1 Euler-Lagrange Equations", "Section",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "In this chapter, we use different methods to determine approximate \
solutions of nonlinear systems possessing internal resonances to orders \
higher than the order at which the influence of the internal resonance first \
appears. To describe the methods with minimum algebra, we consider the free \
oscillations of a two-degree-of-freedom conservative system possessing a \
two-to-one internal resonance and having simple quadratic nonlinearities. In \
particular, we consider a system governed by the ",
  StyleBox["Lagrangian",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]]
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(Lagrangian = 
      \(1\/2\) \(u\_1\^\[Prime]\)[t]\^2 + \(1\/2\) \(u\_2\^\[Prime]\)[t]\^2 - 
        \(1\/2\) \[Omega]\_1\%2\ u\_1[t]\^2 - 
        \(1\/2\) \[Omega]\_2\%2\ u\_2[t]\^2 + \[Delta]\ u\_1[t]\^2\ u\_2[t]; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_2 \[TildeTilde] 2  \[Omega]\_1\)]],
  ". Writing down the Euler-Lagrange equations corresponding to the ",
  StyleBox["Lagrangian",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain the following second-order equations of motion:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(EOM1 = 
      Table[D[D[Lagrangian, \(u\_i\^\[Prime]\)[t]], t] - 
            D[Lagrangian, u\_i[t]] == 0, {i, 2}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
          \(\[Omega]\_1\%2\ u\_1[t]\), "-", 
            \(2\ \[Delta]\ u\_1[t]\ u\_2[t]\), "+", 
            RowBox[{
              SubsuperscriptBox["u", "1", "\[DoublePrime]",
                MultilineFunction->None], "[", "t", "]"}]}], "==", "0"}], 
        ",", 
        RowBox[{
          RowBox[{
          \(\(-\[Delta]\)\ u\_1[t]\^2\), "+", \(\[Omega]\_2\%2\ u\_2[t]\), 
            "+", 
            RowBox[{
              SubsuperscriptBox["u", "2", "\[DoublePrime]",
                MultilineFunction->None], "[", "t", "]"}]}], "==", "0"}]}], 
      "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Approximate solutions of general two-degree-of-freedom system with \
quadratic and cubic nonlinearities having a two-to-one internal resonance can \
be obtained by replacing the ",
  StyleBox["Lagrangian ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "with the Lagrangian corresponding to the general system."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "As discussed in the next section, treating this second-order form, ",
  StyleBox["EOM1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", of the governing equations by using the method of multiple scales may \
lead to results that violate the conservative nature of the system under \
consideration. To determine an approximate solution that preserves the \
conservative nature of the system, we treat a first-order form of the \
governing equations. To transform ",
  StyleBox["EOM1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  StyleBox[" ",
    FontColor->RGBColor[1, 0, 1]],
  "into a system of first-order equations, we form a modified ",
  StyleBox["Lagrangian",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "by introducing two more states ",
  Cell[BoxData[
      \(TraditionalForm\`v\_1[t]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\_2[t]\)]],
  " such that"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(velRule = {\(u\_1\^\[Prime]\)[t] -> v\_1[t], 
        \(u\_2\^\[Prime]\)[t] -> v\_2[t]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Then, the ",
  StyleBox["Lagrangian ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "becomes"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(Lag1 = Lagrangian /. velRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(-\(1\/2\)\)\ \[Omega]\_1\%2\ u\_1[t]\^2 + 
      \[Delta]\ u\_1[t]\^2\ u\_2[t] - 1\/2\ \[Omega]\_2\%2\ u\_2[t]\^2 + 
      1\/2\ v\_1[t]\^2 + 1\/2\ v\_2[t]\^2\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Substituting ",
  StyleBox["Lag1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into Euler-Lagrange equations, we obtain the following first-order \
equations"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq51a = 
      Table[D[D[Lag1, v\_i[t]], t] - D[Lag1, u\_i[t]] == 0, {i, 2}]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
          \(\[Omega]\_1\%2\ u\_1[t]\), "-", 
            \(2\ \[Delta]\ u\_1[t]\ u\_2[t]\), "+", 
            RowBox[{
              SubsuperscriptBox["v", "1", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], "==", "0"}], 
        ",", 
        RowBox[{
          RowBox[{
          \(\(-\[Delta]\)\ u\_1[t]\^2\), "+", \(\[Omega]\_2\%2\ u\_2[t]\), 
            "+", 
            RowBox[{
              SubsuperscriptBox["v", "2", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], "==", "0"}]}], 
      "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Using the ",
  StyleBox["velRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["eq51a",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain the following first-order equations of motion:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(EOM2 = 
      \({velRule /. Rule -> Equal, eq51a} // Transpose\) // Flatten\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SubsuperscriptBox["u", "1", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", \(v\_1[t]\)}], 
        ",", 
        RowBox[{
          RowBox[{
          \(\[Omega]\_1\%2\ u\_1[t]\), "-", 
            \(2\ \[Delta]\ u\_1[t]\ u\_2[t]\), "+", 
            RowBox[{
              SubsuperscriptBox["v", "1", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], "==", "0"}], 
        ",", 
        RowBox[{
          RowBox[{
            SubsuperscriptBox["u", "2", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", \(v\_2[t]\)}], 
        ",", 
        RowBox[{
          RowBox[{
          \(\(-\[Delta]\)\ u\_1[t]\^2\), "+", \(\[Omega]\_2\%2\ u\_2[t]\), 
            "+", 
            RowBox[{
              SubsuperscriptBox["v", "2", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], "==", "0"}]}], 
      "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The corresponding linear system of ",
  StyleBox["EOM2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " can be defined as ",
  Cell[BoxData[
      \(TraditionalForm\`x\& .  = A\ x\)]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is the state vector; that is,"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(states = Table[{u\_i[t], v\_i[t]}, {i, 2}] // Flatten\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_1[t], v\_1[t], u\_2[t], v\_2[t]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Using these states, we find that the coefficient matrix ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " of the linear part of ",
  StyleBox["EOM2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " is given by"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(matrixA = 
      Outer[D, \(#[\([2]\)]&\)\ /@\ \(Solve[EOM2, D[states, t]]\)[\([1]\)] /. 
          \[Delta] -> 0, states]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{0, 1, 0, 0}, {\(-\[Omega]\_1\%2\), 0, 0, 0}, {0, 0, 0, 1}, {0, 0, 
        \(-\[Omega]\_2\%2\), 0}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["whose adjoint is defined by", "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(conjugateRule = {A -> A\&_, A\&_ -> A, 
        Complex[0, n_] -> Complex[0, \(-n\)]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(hermitian[mat_?MatrixQ] := mat /. conjugateRule // Transpose\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "The eigenvalues and eigenvectors of ",
  StyleBox["matrixA",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " can be obtained as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(matrixA // Eigensystem\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{\(-I\)\ \[Omega]\_1, I\ \[Omega]\_1, \(-I\)\ \[Omega]\_2, 
        I\ \[Omega]\_2}, {{I\/\[Omega]\_1, 1, 0, 0}, {
          \(-\(I\/\[Omega]\_1\)\), 1, 0, 0}, {0, 0, I\/\[Omega]\_2, 1}, {0, 
          0, \(-\(I\/\[Omega]\_2\)\), 1}}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Hence, the right eigenvectors of ",
  StyleBox["matrixA",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " corresponding to the eigenvalues ",
  Cell[BoxData[
      \(TraditionalForm\`I\ \[Omega]\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`I\ \[Omega]\_2\)]],
  ", respectively, are"
}], "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(rightVec = \(Eigenvectors[matrixA]\)[\([{2, 4}]\)]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{\(-\(I\/\[Omega]\_1\)\), 1, 0, 0}, {0, 0, \(-\(I\/\[Omega]\_2\)\), 1}}
      \)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Moreover, the left eigenvectors of ",
  StyleBox["matrixA",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " corresponding to the eigenvalues ",
  Cell[BoxData[
      \(TraditionalForm\`I\ \[Omega]\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`I\ \[Omega]\_2\)]],
  ", respectively, are"
}], "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(leftVec = \(Eigenvectors[hermitian[matrixA]]\)[\([{1, 3}]\)]\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{\(-I\)\ \[Omega]\_1, 1, 0, 0}, {0, 0, \(-I\)\ \[Omega]\_2, 1}}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["whose complex conjugate is", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(ccleftVec = leftVec /. conjugateRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{I\ \[Omega]\_1, 1, 0, 0}, {0, 0, I\ \[Omega]\_2, 1}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["5.2 Method of Multiple Scales", "Section",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "We use the method of multiple scales to obtain a second-order uniform \
expansion of the solution of ",
  StyleBox["EOM1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in Section 5.2.1, ",
  StyleBox["EOM2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in Section 5.2.2, and the corresponding first-order complex-valued \
equations of ",
  StyleBox["EOM1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in Section 5.2.3. Again, we need the three time scales ",
  Cell[BoxData[
      \(TraditionalForm\`T\_0 = t, T\_1 = \[Epsilon]\ t, \)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`T\_2 = \[Epsilon]\^2\ t\)]],
  ", which we symbolize by"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(Needs["\<Utilities`Notation`\>"]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{"Symbolize", "[", 
        TagBox[\(T\_0\),
          NotationBoxTag,
          Editable->True], "]"}], ";", 
      RowBox[{"Symbolize", "[", 
        TagBox[\(T\_1\),
          NotationBoxTag,
          Editable->True], "]"}], ";", 
      RowBox[{"Symbolize", "[", 
        TagBox[\(T\_2\),
          NotationBoxTag,
          Editable->True], "]"}], ";"}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(timeScales = {T\_0, T\_1, T\_2}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
In terms of the new time scales, we can express the time derivatives as\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(\ \(dt[1]\)[expr_] := 
      Sum[\[Epsilon]\^i\ D[expr, timeScales[\([i + 1]\)]], {i, 0, 2}]; \n\ 
    \(dt[2]\)[expr_] := 
      \((\(dt[1]\)[\(dt[1]\)[expr]] // Expand)\) /. 
        \[Epsilon]\^\(i_ /; i > 3\) -> 0; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
To represent some of the expressions in a more concise way, we introduce the \
following display rule:\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(displayRule = {
        \(\(Derivative[a__]\)[u_\_\(i_, j_\)]\)[__] :> 
          SequenceForm[
            Times\ @@\ MapIndexed[D\_\(#2[\([1]\)] - 1\)\%#1\ &, {a}], 
            u\_\(i, j\)], 
        \(\(Derivative[a__]\)[A_\_i_]\)[__] :> 
          SequenceForm[Times\ @@\ MapIndexed[D\_\(#2[\([1]\)]\)\%#1\ &, {a}], 
            A\_i], u_\_\(i_, j_\)[__] -> u\_\(i, j\), A_\_i_[__] -> A\_i}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell["5.2.1 Second-Order Real-Valued System", "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using method of multiple scales, we assume that the solution of ",
  StyleBox["EOM1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " can be expressed in the form"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(solRule = 
      u\_i_ -> \((Sum[\[Epsilon]\^j\ u\_\(i, j\)[#1, #2, #3], {j, 3}]\ &)\); 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(multiScales = {u\_i_[t] -> u\_i[T\_0, T\_1, T\_2], 
        \(\(Derivative[n_]\)[u\_i_]\)[t] :> 
          \(dt[n]\)[u\_i[T\_0, T\_1, T\_2]]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["multiScales",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["solRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["EOM1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", expanding the result for small ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon]\)]],
  ", and discarding terms of order higher than ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon]\^3\)]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq521a = 
      \((\(EOM1 /. multiScales\) /. solRule // ExpandAll)\) /. 
        \[Epsilon]\^\(n_ /; n > 3\) -> 0; \neq521a /. displayRule\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{"\[Epsilon]", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_\(1, 1\)\),
                  SequenceForm[ 
                    Power[ 
                      Subscript[ D, 0], 2], 
                    Subscript[ u, 1, 1]],
                  Editable->False], ")"}]}], "+", 
            RowBox[{\(\[Epsilon]\^2\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_\(1, 2\)\),
                  SequenceForm[ 
                    Power[ 
                      Subscript[ D, 0], 2], 
                    Subscript[ u, 1, 2]],
                  Editable->False], ")"}]}], "+", 
            RowBox[{\(\[Epsilon]\^3\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_\(1, 3\)\),
                  SequenceForm[ 
                    Power[ 
                      Subscript[ D, 0], 2], 
                    Subscript[ u, 1, 3]],
                  Editable->False], ")"}]}], "+", 
            RowBox[{"2", " ", \(\[Epsilon]\^2\), " ", 
              RowBox[{"(", 
                
                InterpretationBox[
                  \(\(D\_0\ D\_1\)\[InvisibleSpace]u\_\(1, 1\)\),
                  SequenceForm[ 
                    Times[ 
                      Subscript[ D, 0], 
                      Subscript[ D, 1]], 
                    Subscript[ u, 1, 1]],
                  Editable->False], ")"}]}], "+", 
            RowBox[{"2", " ", \(\[Epsilon]\^3\), " ", 
              RowBox[{"(", 
                
                InterpretationBox[
                  \(\(D\_0\ D\_1\)\[InvisibleSpace]u\_\(1, 2\)\),
                  SequenceForm[ 
                    Times[ 
                      Subscript[ D, 0], 
                      Subscript[ D, 1]], 
                    Subscript[ u, 1, 2]],
                  Editable->False], ")"}]}], "+", 
            RowBox[{\(\[Epsilon]\^3\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\%2\[InvisibleSpace]u\_\(1, 1\)\),
                  SequenceForm[ 
                    Power[ 
                      Subscript[ D, 1], 2], 
                    Subscript[ u, 1, 1]],
                  Editable->False], ")"}]}], "+", 
            RowBox[{"2", " ", \(\[Epsilon]\^3\), " ", 
              RowBox[{"(", 
                
                InterpretationBox[
                  \(\(D\_0\ D\_2\)\[InvisibleSpace]u\_\(1, 1\)\),
                  SequenceForm[ 
                    Times[ 
                      Subscript[ D, 0], 
                      Subscript[ D, 2]], 
                    Subscript[ u, 1, 1]],
                  Editable->False], ")"}]}], "+", 
            \(\[Epsilon]\ \[Omega]\_1\%2\ u\_\(1, 1\)\), "+", 
            \(\[Epsilon]\^2\ \[Omega]\_1\%2\ u\_\(1, 2\)\), "+", 
            \(\[Epsilon]\^3\ \[Omega]\_1\%2\ u\_\(1, 3\)\), "-", 
            \(2\ \[Delta]\ \[Epsilon]\^2\ u\_\(1, 1\)\ u\_\(2, 1\)\), "-", 
            \(2\ \[Delta]\ \[Epsilon]\^3\ u\_\(1, 2\)\ u\_\(2, 1\)\), "-", 
            \(2\ \[Delta]\ \[Epsilon]\^3\ u\_\(1, 1\)\ u\_\(2, 2\)\)}], "==", 
          "0"}], ",", 
        RowBox[{
          RowBox[{
            RowBox[{"\[Epsilon]", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_\(2, 1\)\),
                  SequenceForm[ 
                    Power[ 
                      Subscript[ D, 0], 2], 
                    Subscript[ u, 2, 1]],
                  Editable->False], ")"}]}], "+", 
            RowBox[{\(\[Epsilon]\^2\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_\(2, 2\)\),
                  SequenceForm[ 
                    Power[ 
                      Subscript[ D, 0], 2], 
                    Subscript[ u, 2, 2]],
                  Editable->False], ")"}]}], "+", 
            RowBox[{\(\[Epsilon]\^3\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_\(2, 3\)\),
                  SequenceForm[ 
                    Power[ 
                      Subscript[ D, 0], 2], 
                    Subscript[ u, 2, 3]],
                  Editable->False], ")"}]}], "+", 
            RowBox[{"2", " ", \(\[Epsilon]\^2\), " ", 
              RowBox[{"(", 
                
                InterpretationBox[
                  \(\(D\_0\ D\_1\)\[InvisibleSpace]u\_\(2, 1\)\),
                  SequenceForm[ 
                    Times[ 
                      Subscript[ D, 0], 
                      Subscript[ D, 1]], 
                    Subscript[ u, 2, 1]],
                  Editable->False], ")"}]}], "+", 
            RowBox[{"2", " ", \(\[Epsilon]\^3\), " ", 
              RowBox[{"(", 
                
                InterpretationBox[
                  \(\(D\_0\ D\_1\)\[InvisibleSpace]u\_\(2, 2\)\),
                  SequenceForm[ 
                    Times[ 
                      Subscript[ D, 0], 
                      Subscript[ D, 1]], 
                    Subscript[ u, 2, 2]],
                  Editable->False], ")"}]}], "+", 
            RowBox[{\(\[Epsilon]\^3\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\%2\[InvisibleSpace]u\_\(2, 1\)\),
                  SequenceForm[ 
                    Power[ 
                      Subscript[ D, 1], 2], 
                    Subscript[ u, 2, 1]],
                  Editable->False], ")"}]}], "+", 
            RowBox[{"2", " ", \(\[Epsilon]\^3\), " ", 
              RowBox[{"(", 
                
                InterpretationBox[
                  \(\(D\_0\ D\_2\)\[InvisibleSpace]u\_\(2, 1\)\),
                  SequenceForm[ 
                    Times[ 
                      Subscript[ D, 0], 
                      Subscript[ D, 2]], 
                    Subscript[ u, 2, 1]],
                  Editable->False], ")"}]}], "-", 
            \(\[Delta]\ \[Epsilon]\^2\ u\_\(1, 1\)\%2\), "-", 
            \(2\ \[Delta]\ \[Epsilon]\^3\ u\_\(1, 1\)\ u\_\(1, 2\)\), "+", 
            \(\[Epsilon]\ \[Omega]\_2\%2\ u\_\(2, 1\)\), "+", 
            \(\[Epsilon]\^2\ \[Omega]\_2\%2\ u\_\(2, 2\)\), "+", 
            \(\[Epsilon]\^3\ \[Omega]\_2\%2\ u\_\(2, 3\)\)}], "==", "0"}]}], 
      "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[
"Equating coefficients of like powers of \[Epsilon], we obtain"], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eqEps = 
      \(Rest[Thread[CoefficientList[Subtract\ @@\ #, \[Epsilon]] == 0]]&\)\ /@
          \ eq521a // Transpose; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
To place the linear operators on one side and the nonhomogeneous terms on the \
other side, we define\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(eqOrder[i_] := 
      \((\(#[\([1]\)]\ &\)\ /@\ eqEps[\([1]\)] /. 
              u_\_\(k_, 1\) -> u\_\(k, i\))\) == 
          \((\(#[\([1]\)]\ &\)\ /@\ eqEps[\([1]\)] /. 
                u_\_\(k_, 1\) -> u\_\(k, i\))\) - 
            \((\(#[\([1]\)]\ &\)\ /@\ eqEps[\([i]\)])\) // Thread\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using ",
  StyleBox["eqOrder[i]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["displayRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we rewrite ",
  StyleBox["eqEps",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in a concise way as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[{
    \(eqOrder[1] /. displayRule // TableForm\), 
    \(eqOrder[2] /. displayRule // TableForm\), 
    \(eqOrder[3] /. displayRule // TableForm\)}], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_\(1, 1\)\),
                  SequenceForm[ 
                    Power[ 
                      Subscript[ D, 0], 2], 
                    Subscript[ u, 1, 1]],
                  Editable->False], "+", \(\[Omega]\_1\%2\ u\_\(1, 1\)\)}], 
              "==", "0"}]},
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_\(2, 1\)\),
                  SequenceForm[ 
                    Power[ 
                      Subscript[ D, 0], 2], 
                    Subscript[ u, 2, 1]],
                  Editable->False], "+", \(\[Omega]\_2\%2\ u\_\(2, 1\)\)}], 
              "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Power[ 
                Subscript[ D, 0], 2], 
              Subscript[ u, 1, 1]], 
            Times[ 
              Power[ 
                Subscript[ \[Omega], 1], 2], 
              Subscript[ u, 1, 1]]], 0], 
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Power[ 
                Subscript[ D, 0], 2], 
              Subscript[ u, 2, 1]], 
            Times[ 
              Power[ 
                Subscript[ \[Omega], 2], 2], 
              Subscript[ u, 2, 1]]], 0]}]]], "Output",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_\(1, 2\)\),
                  SequenceForm[ 
                    Power[ 
                      Subscript[ D, 0], 2], 
                    Subscript[ u, 1, 2]],
                  Editable->False], "+", \(\[Omega]\_1\%2\ u\_\(1, 2\)\)}], 
              "==", 
              RowBox[{
                RowBox[{\(-2\), " ", 
                  RowBox[{"(", 
                    
                    InterpretationBox[
                      \(\(D\_0\ D\_1\)\[InvisibleSpace]u\_\(1, 1\)\),
                      SequenceForm[ 
                        Times[ 
                          Subscript[ D, 0], 
                          Subscript[ D, 1]], 
                        Subscript[ u, 1, 1]],
                      Editable->False], ")"}]}], "+", 
                \(2\ \[Delta]\ u\_\(1, 1\)\ u\_\(2, 1\)\)}]}]},
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_\(2, 2\)\),
                  SequenceForm[ 
                    Power[ 
                      Subscript[ D, 0], 2], 
                    Subscript[ u, 2, 2]],
                  Editable->False], "+", \(\[Omega]\_2\%2\ u\_\(2, 2\)\)}], 
              "==", 
              RowBox[{
                RowBox[{\(-2\), " ", 
                  RowBox[{"(", 
                    
                    InterpretationBox[
                      \(\(D\_0\ D\_1\)\[InvisibleSpace]u\_\(2, 1\)\),
                      SequenceForm[ 
                        Times[ 
                          Subscript[ D, 0], 
                          Subscript[ D, 1]], 
                        Subscript[ u, 2, 1]],
                      Editable->False], ")"}]}], "+", 
                \(\[Delta]\ u\_\(1, 1\)\%2\)}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Power[ 
                Subscript[ D, 0], 2], 
              Subscript[ u, 1, 2]], 
            Times[ 
              Power[ 
                Subscript[ \[Omega], 1], 2], 
              Subscript[ u, 1, 2]]], 
          Plus[ 
            Times[ -2, 
              SequenceForm[ 
                Times[ 
                  Subscript[ D, 0], 
                  Subscript[ D, 1]], 
                Subscript[ u, 1, 1]]], 
            Times[ 2, \[Delta], 
              Subscript[ u, 1, 1], 
              Subscript[ u, 2, 1]]]], 
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Power[ 
                Subscript[ D, 0], 2], 
              Subscript[ u, 2, 2]], 
            Times[ 
              Power[ 
                Subscript[ \[Omega], 2], 2], 
              Subscript[ u, 2, 2]]], 
          Plus[ 
            Times[ -2, 
              SequenceForm[ 
                Times[ 
                  Subscript[ D, 0], 
                  Subscript[ D, 1]], 
                Subscript[ u, 2, 1]]], 
            Times[ \[Delta], 
              Power[ 
                Subscript[ u, 1, 1], 2]]]]}]]], "Output",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_\(1, 3\)\),
                  SequenceForm[ 
                    Power[ 
                      Subscript[ D, 0], 2], 
                    Subscript[ u, 1, 3]],
                  Editable->False], "+", \(\[Omega]\_1\%2\ u\_\(1, 3\)\)}], 
              "==", 
              RowBox[{
                RowBox[{\(-2\), " ", 
                  RowBox[{"(", 
                    
                    InterpretationBox[
                      \(\(D\_0\ D\_1\)\[InvisibleSpace]u\_\(1, 2\)\),
                      SequenceForm[ 
                        Times[ 
                          Subscript[ D, 0], 
                          Subscript[ D, 1]], 
                        Subscript[ u, 1, 2]],
                      Editable->False], ")"}]}], "-", 
                InterpretationBox[\(D\_1\%2\[InvisibleSpace]u\_\(1, 1\)\),
                  SequenceForm[ 
                    Power[ 
                      Subscript[ D, 1], 2], 
                    Subscript[ u, 1, 1]],
                  Editable->False], "-", 
                RowBox[{"2", " ", 
                  RowBox[{"(", 
                    
                    InterpretationBox[
                      \(\(D\_0\ D\_2\)\[InvisibleSpace]u\_\(1, 1\)\),
                      SequenceForm[ 
                        Times[ 
                          Subscript[ D, 0], 
                          Subscript[ D, 2]], 
                        Subscript[ u, 1, 1]],
                      Editable->False], ")"}]}], "+", 
                \(2\ \[Delta]\ u\_\(1, 2\)\ u\_\(2, 1\)\), "+", 
                \(2\ \[Delta]\ u\_\(1, 1\)\ u\_\(2, 2\)\)}]}]},
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_\(2, 3\)\),
                  SequenceForm[ 
                    Power[ 
                      Subscript[ D, 0], 2], 
                    Subscript[ u, 2, 3]],
                  Editable->False], "+", \(\[Omega]\_2\%2\ u\_\(2, 3\)\)}], 
              "==", 
              RowBox[{
                RowBox[{\(-2\), " ", 
                  RowBox[{"(", 
                    
                    InterpretationBox[
                      \(\(D\_0\ D\_1\)\[InvisibleSpace]u\_\(2, 2\)\),
                      SequenceForm[ 
                        Times[ 
                          Subscript[ D, 0], 
                          Subscript[ D, 1]], 
                        Subscript[ u, 2, 2]],
                      Editable->False], ")"}]}], "-", 
                InterpretationBox[\(D\_1\%2\[InvisibleSpace]u\_\(2, 1\)\),
                  SequenceForm[ 
                    Power[ 
                      Subscript[ D, 1], 2], 
                    Subscript[ u, 2, 1]],
                  Editable->False], "-", 
                RowBox[{"2", " ", 
                  RowBox[{"(", 
                    
                    InterpretationBox[
                      \(\(D\_0\ D\_2\)\[InvisibleSpace]u\_\(2, 1\)\),
                      SequenceForm[ 
                        Times[ 
                          Subscript[ D, 0], 
                          Subscript[ D, 2]], 
                        Subscript[ u, 2, 1]],
                      Editable->False], ")"}]}], "+", 
                \(2\ \[Delta]\ u\_\(1, 1\)\ u\_\(1, 2\)\)}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Power[ 
                Subscript[ D, 0], 2], 
              Subscript[ u, 1, 3]], 
            Times[ 
              Power[ 
                Subscript[ \[Omega], 1], 2], 
              Subscript[ u, 1, 3]]], 
          Plus[ 
            Times[ -2, 
              SequenceForm[ 
                Times[ 
                  Subscript[ D, 0], 
                  Subscript[ D, 1]], 
                Subscript[ u, 1, 2]]], 
            Times[ -1, 
              SequenceForm[ 
                Power[ 
                  Subscript[ D, 1], 2], 
                Subscript[ u, 1, 1]]], 
            Times[ -2, 
              SequenceForm[ 
                Times[ 
                  Subscript[ D, 0], 
                  Subscript[ D, 2]], 
                Subscript[ u, 1, 1]]], 
            Times[ 2, \[Delta], 
              Subscript[ u, 1, 2], 
              Subscript[ u, 2, 1]], 
            Times[ 2, \[Delta], 
              Subscript[ u, 1, 1], 
              Subscript[ u, 2, 2]]]], 
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Power[ 
                Subscript[ D, 0], 2], 
              Subscript[ u, 2, 3]], 
            Times[ 
              Power[ 
                Subscript[ \[Omega], 2], 2], 
              Subscript[ u, 2, 3]]], 
          Plus[ 
            Times[ -2, 
              SequenceForm[ 
                Times[ 
                  Subscript[ D, 0], 
                  Subscript[ D, 1]], 
                Subscript[ u, 2, 2]]], 
            Times[ -1, 
              SequenceForm[ 
                Power[ 
                  Subscript[ D, 1], 2], 
                Subscript[ u, 2, 1]]], 
            Times[ -2, 
              SequenceForm[ 
                Times[ 
                  Subscript[ D, 0], 
                  Subscript[ D, 2]], 
                Subscript[ u, 2, 1]]], 
            Times[ 2, \[Delta], 
              Subscript[ u, 1, 1], 
              Subscript[ u, 1, 2]]]]}]]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell["First-Order Equations: Linear System", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "To obtain the solution of ",
  StyleBox["eqOrder[1]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " by using ",
  StyleBox["DSolve",
    FontWeight->"Bold"],
  ", we transform ",
  StyleBox["eqOrder[1]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into a set of ordinary-differential equations as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order1Eq = eqOrder[1] /. u\_\(i_, j_\) -> \((u\_\(i, j\)[#1]\ &)\)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{\(\[Omega]\_1\%2\ u\_\(1, 1\)[T\_0]\), "+", 
            RowBox[{
              SubsuperscriptBox["u", \(1, 1\), "\[DoublePrime]",
                MultilineFunction->None], "[", \(T\_0\), "]"}]}], "==", 
          "0"}], ",", 
        RowBox[{
          RowBox[{\(\[Omega]\_2\%2\ u\_\(2, 1\)[T\_0]\), "+", 
            RowBox[{
              SubsuperscriptBox["u", \(2, 1\), "\[DoublePrime]",
                MultilineFunction->None], "[", \(T\_0\), "]"}]}], "==", 
          "0"}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The particular solution of ",
  StyleBox["order1Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " can be expressed as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1p = 
      \(DSolve[order1Eq, {u\_\(1, 1\)[T\_0], u\_\(2, 1\)[T\_0]}, T\_0]\)[
          \([1]\)] /. C[_] -> 0\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_\(1, 1\)[T\_0] \[Rule] 0, u\_\(2, 1\)[T\_0] \[Rule] 0}\)], "Output",\

  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["Hence, we write the first-order solution in function form as", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1 = 
      Table[u\_\(i, 1\) -> 
          Function[{T\_0, T\_1, T\_2}, 
            A\_i[T\_1, T\_2]\ Exp[I\ \[Omega]\_i\ T\_0] + 
                  A\&_\_i[T\_1, T\_2]\ Exp[\(-I\)\ \[Omega]\_i\ T\_0] + 
                  u\_\(i, 1\)[T\_0] /. sol1p // Evaluate], {i, 2}]\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_\(1, 1\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1[T\_1, T\_2] + 
            E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ A\&_\_1[T\_1, T\_2]], 
      u\_\(2, 1\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2[T\_1, T\_2] + 
            E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ A\&_\_2[T\_1, T\_2]]}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Second-Order Equations", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["sol1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["eqOrder[2]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order2Eq = eqOrder[2] /. sol1 // ExpandAll; \n
    order2Eq /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_\(1, 2\)\),
              SequenceForm[ 
                Power[ 
                  Subscript[ D, 0], 2], 
                Subscript[ u, 1, 2]],
              Editable->False], "+", \(\[Omega]\_1\%2\ u\_\(1, 2\)\)}], 
          "==", 
          RowBox[{
          \(2\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ \[Delta]\ 
              A\_1\ A\_2\), "-", 
            RowBox[{
            "2", " ", "I", " ", \(E\^\(I\ T\_0\ \[Omega]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}], " ", \(\[Omega]\_1\)}], "+", 
            RowBox[{
            "2", " ", "I", " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 1]],
                  Editable->False], ")"}], " ", \(\[Omega]\_1\)}], "+", 
            \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
              \[Delta]\ A\_2\ A\&_\_1\), "+", 
            \(2\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
              \[Delta]\ A\_1\ A\&_\_2\), "+", 
            \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
              \[Delta]\ A\&_\_1\ A\&_\_2\)}]}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_\(2, 2\)\),
              SequenceForm[ 
                Power[ 
                  Subscript[ D, 0], 2], 
                Subscript[ u, 2, 2]],
              Editable->False], "+", \(\[Omega]\_2\%2\ u\_\(2, 2\)\)}], 
          "==", 
          RowBox[{
          \(E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\ A\_1\%2\), "-", 
            RowBox[{
            "2", " ", "I", " ", \(E\^\(I\ T\_0\ \[Omega]\_2\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}], " ", \(\[Omega]\_2\)}], "+", 
            RowBox[{
            "2", " ", "I", " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 2]],
                  Editable->False], ")"}], " ", \(\[Omega]\_2\)}], "+", 
            \(2\ \[Delta]\ A\_1\ A\&_\_1\), "+", 
            \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\ 
              A\&_\_1\%2\)}]}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "To describe quantitatively the nearness of the ",
  StyleBox["two-to-one internal resonance",
    FontColor->RGBColor[0, 0, 1]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_2 \[TildeTilde] 2  \[Omega]\_1\)]],
  ", we introduce the detuning parameter \[Sigma] defined by"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ResonanceCond = {
        \[Omega]\_2 == 2  \[Omega]\_1 + \[Epsilon]\ \[Sigma]}; \)\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "In eliminating secular terms, we need to express ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_2\)]],
  " in terms of ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_1\)]],
  " in some of the equations and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_1\)]],
  " in terms of ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_2\)]],
  " in the other equations. To accomplish this, we let"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(omgList = Table[\[Omega]\_i, {i, 2}]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(omgRule = 
      \(\(Solve[ResonanceCond, Drop[omgList, {#}]]\)[\([1]\)]\ &\)\ /@
        \ {1, 2}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{\[Omega]\_2 \[Rule] \[Epsilon]\ \[Sigma] + 2\ \[Omega]\_1}, {
        \[Omega]\_1 \[Rule] 
          1\/2\ \((\(-\[Epsilon]\)\ \[Sigma] + \[Omega]\_2)\)}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
To convert small-divisor terms into secular terms, we define the rule\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(expRule1[j_] := 
      Exp[arg_] :> 
        Exp[Expand[arg /. omgRule[\([j]\)]] /. \[Epsilon]\ T\_0 -> T\_1]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["expRule1[i]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into the right-hand sides of ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and collecting the coefficients of ",
  Cell[BoxData[
      \(TraditionalForm\`E\^\(I\ \[Omega]\_i\ T\_0\)\)]],
  ", we obtain the solvability conditions as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(SCond1 = 
      \(Coefficient[order2Eq[\([#, 2]\)] /. expRule1[#], 
              Exp[I\ \[Omega]\_#\ T\_0]] == 0\ &\)\ /@\ {1, 2}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
          \(2\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ A\_2[T\_1, T\_2]\ 
              A\&_\_1[T\_1, T\_2]\), "-", 
            RowBox[{"2", " ", "I", " ", \(\[Omega]\_1\), " ", 
              RowBox[{
                SubsuperscriptBox["A", "1", 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}]}], 
          "==", "0"}], ",", 
        RowBox[{
          RowBox[{
          \(E\^\(\(-I\)\ T\_1\ \[Sigma]\)\ \[Delta]\ A\_1[T\_1, T\_2]\^2\), 
            "-", 
            RowBox[{"2", " ", "I", " ", \(\[Omega]\_2\), " ", 
              RowBox[{
                SubsuperscriptBox["A", "2", 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}]}], 
          "==", "0"}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Because the system is conservative, the modulation equations given by ",
  StyleBox["SCond1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " must be derivable from a Lagrangian. These equations are the \
Euler-Lagrange equations corresponding to the Lagrangian"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{"Lag", "=", 
        RowBox[{
        \(E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ A\_2[T\_1, T\_2]\ 
            A\&_\_1[T\_1, T\_2]\^2\), "+", 
          \(E\^\(\(-I\)\ T\_1\ \[Sigma]\)\ \[Delta]\ A\_1[T\_1, T\_2]\^2\ 
            A\&_\_2[T\_1, T\_2]\), "-", 
          RowBox[{
          "I", " ", \(\[Omega]\_1\), " ", \(A\&_\_1[T\_1, T\_2]\), " ", 
            RowBox[{
              SubsuperscriptBox["A", "1", 
                TagBox[\((1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], "-", 
          RowBox[{
          "I", " ", \(\[Omega]\_2\), " ", \(A\&_\_2[T\_1, T\_2]\), " ", 
            RowBox[{
              SubsuperscriptBox["A", "2", 
                TagBox[\((1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], "+", 
          "\n", "\t", 
          RowBox[{"I", " ", \(\[Omega]\_1\), " ", \(A\_1[T\_1, T\_2]\), " ", 
            RowBox[{
              SubsuperscriptBox[\(A\&_\), "1", 
                TagBox[\((1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], "+", 
          RowBox[{"I", " ", \(\[Omega]\_2\), " ", \(A\_2[T\_1, T\_2]\), " ", 
            RowBox[{
              SubsuperscriptBox[\(A\&_\), "2", 
                TagBox[\((1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}]}]}], 
      ";"}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["because", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"alSCond1", "=", 
      RowBox[{"Table", "[", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{"-", 
                RowBox[{"D", "[", 
                  RowBox[{
                    RowBox[{"D", "[", 
                      RowBox[{"Lag", ",", 
                        RowBox[{
                          SubsuperscriptBox[\(A\&_\), "k", 
                            TagBox[\((1, 0)\),
                              Derivative],
                            MultilineFunction->None], "[", \(T\_1, T\_2\), 
                          "]"}]}], "]"}], ",", \(T\_1\)}], "]"}]}], "+", 
              \(D[Lag, A\&_\_k[T\_1, T\_2]]\)}], "==", "0"}], ",", 
          \({k, 2}\)}], "]"}]}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
          \(2\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ A\_2[T\_1, T\_2]\ 
              A\&_\_1[T\_1, T\_2]\), "-", 
            RowBox[{"2", " ", "I", " ", \(\[Omega]\_1\), " ", 
              RowBox[{
                SubsuperscriptBox["A", "1", 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}]}], 
          "==", "0"}], ",", 
        RowBox[{
          RowBox[{
          \(E\^\(\(-I\)\ T\_1\ \[Sigma]\)\ \[Delta]\ A\_1[T\_1, T\_2]\^2\), 
            "-", 
            RowBox[{"2", " ", "I", " ", \(\[Omega]\_2\), " ", 
              RowBox[{
                SubsuperscriptBox["A", "2", 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}]}], 
          "==", "0"}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Equations ",
  StyleBox["alSCond1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " are identical to equations ",
  StyleBox["SCond1 ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "as shown below"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(alSCond1 === SCond1\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(True\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
Alternatively, we can determine the modulation equations by using the \
time-averaged Lagrangian. To this end, we first define the rule\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(expRule2 = 
      Exp[a_] :> 
        Exp[Expand[a /. \((ResonanceCond /. Equal -> Rule)\)] /. 
            \[Epsilon]\ T\_0 -> T\_1]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["multiScales",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", ",
  StyleBox["solRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", ",
  StyleBox["sol1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", and ",
  StyleBox["expRule2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into the ",
  StyleBox["Lagrangian",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and selecting the slow-varying terms, we obtain the following \
time-averaged Lagrangian:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(TAL1 = 
      Select[\((
              \(\((\(Lagrangian /. multiScales\) /. solRule // Expand)\) /. 
                    \[Epsilon]\^\(n_ /; n > 3\) -> 0\) /. sol1 // Expand)
              \) /. expRule2, FreeQ[#, T\_0]\ &] /. \[Epsilon] -> 1; \n
    TAL1 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{"I", " ", 
        RowBox[{"(", 
          InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_1\),
            SequenceForm[ 
              Subscript[ D, 1], 
              Subscript[ 
                OverBar[ A], 1]],
            Editable->False], ")"}], " ", \(A\_1\), " ", \(\[Omega]\_1\)}], 
      "+", 
      RowBox[{"I", " ", 
        RowBox[{"(", 
          InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_2\),
            SequenceForm[ 
              Subscript[ D, 1], 
              Subscript[ 
                OverBar[ A], 2]],
            Editable->False], ")"}], " ", \(A\_2\), " ", \(\[Omega]\_2\)}], 
      "-", 
      RowBox[{"I", " ", 
        RowBox[{"(", 
          InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
            SequenceForm[ 
              Subscript[ D, 1], 
              Subscript[ A, 1]],
            Editable->False], ")"}], " ", \(\[Omega]\_1\), " ", 
        \(A\&_\_1\)}], "+", 
      \(E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ A\_2\ A\&_\_1\%2\), "+", 
      \(E\^\(\(-I\)\ T\_1\ \[Sigma]\)\ \[Delta]\ A\_1\%2\ A\&_\_2\), "-", 
      RowBox[{"I", " ", 
        RowBox[{"(", 
          InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
            SequenceForm[ 
              Subscript[ D, 1], 
              Subscript[ A, 2]],
            Editable->False], ")"}], " ", \(\[Omega]\_2\), " ", 
        \(A\&_\_2\)}]}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "One can easily verify that ",
  StyleBox["TAL1 ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "is identical to ",
  StyleBox["Lag",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ". In fact,"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(TAL1 == Lag\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(True\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Next, we rewrite ",
  StyleBox["SCond1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"SCond1Rule1", "=", 
      RowBox[{
        RowBox[{"Solve", "[", 
          RowBox[{"SCond1", ",", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{
                  SubsuperscriptBox["A", "1", 
                    TagBox[\((1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}], 
                ",", 
                RowBox[{
                  SubsuperscriptBox["A", "2", 
                    TagBox[\((1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], 
              "}"}]}], "]"}], "[", \([1]\), "]"}]}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SubsuperscriptBox["A", "1", 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}], 
          "\[Rule]", 
          \(-\(\(I\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ A\_2[T\_1, T\_2]\ 
                  A\&_\_1[T\_1, T\_2]\)\/\[Omega]\_1\)\)}], ",", 
        RowBox[{
          RowBox[{
            SubsuperscriptBox["A", "2", 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}], 
          "\[Rule]", 
          \(-\(\(I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\)\ \[Delta]\ 
                  A\_1[T\_1, T\_2]\^2\)\/\(2\ \[Omega]\_2\)\)\)}]}], "}"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["whose complex conjugate is", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ccSCond1Rule1 = SCond1Rule1 /. conjugateRule; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "To solve for the particular solution of ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we express the detuning parameter ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\)]],
  " in terms of the ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_i\)]],
  "; that is,"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sigRule = \(Solve[ResonanceCond, \[Sigma]]\)[\([1]\)]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Sigma] \[Rule] \(-\(\(2\ \[Omega]\_1 - \[Omega]\_2\)\/\[Epsilon]\)\)}
      \)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Moreover, we express the scale ",
  Cell[BoxData[
      \(TraditionalForm\`T\_1\)]],
  " in terms of the scale ",
  Cell[BoxData[
      \(TraditionalForm\`T\_0\)]],
  " by using the rule"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(expRule3 = 
      Exp[a_] :> Exp[\(a /. T\_1 -> \[Epsilon]\ T\_0\) /. sigRule // Expand]; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "With the solvability conditions and the ",
  StyleBox["expRule3",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " becomes"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order2Eqm = 
      \(\(order2Eq /. SCond1Rule1\) /. ccSCond1Rule1\) /. expRule3; \n
    order2Eqm /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_\(1, 2\)\),
              SequenceForm[ 
                Power[ 
                  Subscript[ D, 0], 2], 
                Subscript[ u, 1, 2]],
              Editable->False], "+", \(\[Omega]\_1\%2\ u\_\(1, 2\)\)}], "==", 
          \(2\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ \[Delta]\ 
              A\_1\ A\_2 + 
            2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
              \[Delta]\ A\&_\_1\ A\&_\_2\)}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_\(2, 2\)\),
              SequenceForm[ 
                Power[ 
                  Subscript[ D, 0], 2], 
                Subscript[ u, 2, 2]],
              Editable->False], "+", \(\[Omega]\_2\%2\ u\_\(2, 2\)\)}], "==", 
          \(2\ \[Delta]\ A\_1\ A\&_\_1\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Again, to use ",
  StyleBox["DSolve",
    FontWeight->"Bold"],
  ", we first transform ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into a set of ordinary-differential equations and then obtain the \
particular solution of ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2p = 
      \(DSolve[order2Eqm /. u\_\(i_, j_\) -> \((u\_\(i, j\)[#1]\ &)\), {
                u\_\(1, 2\)[T\_0], u\_\(2, 2\)[T\_0]}, T\_0]\)[\([1]\)] /. 
          C[_] -> 0 // Simplify\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_\(1, 2\)[T\_0] \[Rule] 
        \(-\(\(1\/\(\[Omega]\_2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\) 
            \((2\ E\^\(\(-I\)\ T\_0\ \((\[Omega]\_1 + \[Omega]\_2)\)\)\ 
                \[Delta]\ 
                \((E\^\(2\ I\ T\_0\ \((\[Omega]\_1 + \[Omega]\_2)\)\)\ 
                      A\_1[T\_1, T\_2]\ A\_2[T\_1, T\_2] + 
                    A\&_\_1[T\_1, T\_2]\ A\&_\_2[T\_1, T\_2])\))\)\)\), 
      u\_\(2, 2\)[T\_0] \[Rule] 
        \(2\ \[Delta]\ A\_1[T\_1, T\_2]\ A\&_\_1[T\_1, T\_2]\)\/\[Omega]\_2
            \%2}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
The second-order solution can be expressed in pure function form as\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2 = 
      Table[u\_\(i, 2\) -> 
          Function[{T\_0, T\_1, T\_2}, 
            \(B\_i[T\_1, T\_2]\ Exp[I\ \[Omega]\_i\ T\_0] + 
                  B\&_\_i[T\_1, T\_2]\ Exp[\(-I\)\ \[Omega]\_i\ T\_0] + 
                  sol2p[\([i, 2]\)] // Expand\) // Evaluate], {i, 2}]; \n
    sol2 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_\(1, 2\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          \(-\(\(2\ E\^\(I\ T\_0\ \((\[Omega]\_1 + \[Omega]\_2)\)\)\ 
                    \[Delta]\ A\_1\ A\_2\)\/\(\[Omega]\_2\ 
                    \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)\) + 
            E\^\(I\ T\_0\ \[Omega]\_1\)\ B\_1 - 
            \(2\ E\^\(\(-I\)\ T\_0\ \((\[Omega]\_1 + \[Omega]\_2)\)\)\ 
                \[Delta]\ A\&_\_1\ A\&_\_2\)\/\(\[Omega]\_2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
            E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ B\&_\_1], 
      u\_\(2, 2\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          E\^\(I\ T\_0\ \[Omega]\_2\)\ B\_2 + 
            \(2\ \[Delta]\ A\_1\ A\&_\_1\)\/\[Omega]\_2\%2 + 
            E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ B\&_\_2]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "As shown below, the obtained modulation equations will violate the \
conservative nature of system unless we include an appropriate part of the \
homogeneous solutions of the second-order problem. This is the reason why we \
included the homogeneous solutions with the undetermined functions ",
  Cell[BoxData[
      \(TraditionalForm\`B\_i[t]\)]],
  ". They will be determined so as to preserve the conservative nature of the \
system."
}], "Text",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell["Third-Order Equations", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["sol1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["sol2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["eqOrder[3]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(order3Eq = \(eqOrder[3] /. sol1\) /. sol2 // ExpandAll; \)\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["expRule1[i]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into the right-hand sides of ",
  StyleBox["order3Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and collecting the coefficients of ",
  Cell[BoxData[
      \(TraditionalForm\`\(E\^\(I\ \[Omega]\_i\ T\_0\), \)\)]],
  " we obtain the solvability conditions as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(SCond2 = 
      \(Coefficient[order3Eq[\([#, 2]\)] /. expRule1[#], 
              Exp[I\ \[Omega]\_#\ T\_0]] == 0\ &\)\ /@\ {1, 2}; \n
    SCond2 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\%2\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Power[ 
                      Subscript[ D, 1], 2], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}]}], "-", 
            RowBox[{"2", " ", "I", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]B\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ B, 1]],
                  Editable->False], ")"}], " ", \(\[Omega]\_1\)}], "-", 
            RowBox[{"2", " ", "I", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_2\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 2], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}], " ", \(\[Omega]\_1\)}], "+", 
            \(2\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ B\_2\ A\&_\_1\), "+", 
            \(\(4\ \[Delta]\^2\ A\_1\%2\ A\&_\_1\)\/\[Omega]\_2\%2\), "-", 
            \(\(4\ \[Delta]\^2\ A\_1\ A\_2\ 
                  A\&_\_2\)\/\(2\ \[Omega]\_1\ \[Omega]\_2 + 
                  \[Omega]\_2\%2\)\), "+", 
            \(2\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ A\_2\ B\&_\_1\)}], "==", 
          "0"}], ",", 
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\%2\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Power[ 
                      Subscript[ D, 1], 2], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}]}], "+", 
            \(2\ E\^\(\(-I\)\ T\_1\ \[Sigma]\)\ \[Delta]\ A\_1\ B\_1\), "-", 
            RowBox[{"2", " ", "I", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]B\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ B, 2]],
                  Editable->False], ")"}], " ", \(\[Omega]\_2\)}], "-", 
            RowBox[{"2", " ", "I", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_2\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 2], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}], " ", \(\[Omega]\_2\)}], "-", 
            \(\(4\ \[Delta]\^2\ A\_1\ A\_2\ 
                  A\&_\_1\)\/\(2\ \[Omega]\_1\ \[Omega]\_2 + 
                  \[Omega]\_2\%2\)\)}], "==", "0"}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Using the solvability conditions at second order, ",
  StyleBox["SCond1Rule1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(SCond1Rule2 = \(D[SCond1Rule1, T\_1] /. SCond1Rule1\) /. ccSCond1Rule1; 
    \nSCond1Rule2 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          InterpretationBox[\(D\_1\%2\[InvisibleSpace]A\_1\),
            SequenceForm[ 
              Power[ 
                Subscript[ D, 1], 2], 
              Subscript[ A, 1]],
            Editable->False], "\[Rule]", 
          \(\(E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[Sigma]\ A\_2\ 
                A\&_\_1\)\/\[Omega]\_1 - 
            \(\[Delta]\^2\ A\_1\%2\ A\&_\_1\)\/\(2\ \[Omega]\_1\ 
                \[Omega]\_2\) + 
            \(\[Delta]\^2\ A\_1\ A\_2\ A\&_\_2\)\/\[Omega]\_1\%2\)}], ",", 
        RowBox[{
          InterpretationBox[\(D\_1\%2\[InvisibleSpace]A\_2\),
            SequenceForm[ 
              Power[ 
                Subscript[ D, 1], 2], 
              Subscript[ A, 2]],
            Editable->False], "\[Rule]", 
          \(\(-\(\(E\^\(\(-I\)\ T\_1\ \[Sigma]\)\ \[Delta]\ \[Sigma]\ 
                    A\_1\%2\)\/\(2\ \[Omega]\_2\)\)\) - 
            \(\[Delta]\^2\ A\_1\ A\_2\ A\&_\_1\)\/\(\[Omega]\_1\ 
                \[Omega]\_2\)\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
Hence, we rewrite the solvability conditions at third order as\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"SCond2Rule1", "=", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{"Solve", "[", 
                RowBox[{"SCond2", ",", 
                  RowBox[{"{", 
                    RowBox[{
                      RowBox[{
                        SubsuperscriptBox["A", "1", 
                          TagBox[\((0, 1)\),
                            Derivative],
                          MultilineFunction->None], "[", \(T\_1, T\_2\), 
                        "]"}], ",", 
                      RowBox[{
                        SubsuperscriptBox["A", "2", 
                          TagBox[\((0, 1)\),
                            Derivative],
                          MultilineFunction->None], "[", \(T\_1, T\_2\), 
                        "]"}]}], "}"}]}], "]"}], "[", \([1]\), "]"}], "/.", 
            "SCond1Rule2"}], "//", "ExpandAll"}]}], ";", "\n", 
      \(SCond2Rule1 /. displayRule\)}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          InterpretationBox[\(D\_2\[InvisibleSpace]A\_1\),
            SequenceForm[ 
              Subscript[ D, 2], 
              Subscript[ A, 1]],
            Editable->False], "\[Rule]", 
          RowBox[{
            RowBox[{"-", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]B\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ B, 1]],
                  Editable->False], ")"}]}], "+", 
            \(\(I\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[Sigma]\ A\_2\ 
                  A\&_\_1\)\/\(2\ \[Omega]\_1\%2\)\), "-", 
            \(\(I\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ B\_2\ 
                  A\&_\_1\)\/\[Omega]\_1\), "-", 
            \(\(2\ I\ \[Delta]\^2\ A\_1\%2\ A\&_\_1\)\/\(\[Omega]\_1\ 
                  \[Omega]\_2\%2\)\), "-", 
            \(\(I\ \[Delta]\^2\ A\_1\%2\ A\&_\_1\)\/\(4\ \[Omega]\_1\%2\ 
                  \[Omega]\_2\)\), "+", 
            \(\(I\ \[Delta]\^2\ A\_1\ A\_2\ A\&_\_2\)\/\(2\ 
                  \[Omega]\_1\%3\)\), "+", 
            \(\(2\ I\ \[Delta]\^2\ A\_1\ A\_2\ A\&_\_2\)\/\(\[Omega]\_1\ 
                  \((2\ \[Omega]\_1\ \[Omega]\_2 + \[Omega]\_2\%2)\)\)\), 
            "-", \(\(I\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ A\_2\ 
                  B\&_\_1\)\/\[Omega]\_1\)}]}], ",", 
        RowBox[{
          InterpretationBox[\(D\_2\[InvisibleSpace]A\_2\),
            SequenceForm[ 
              Subscript[ D, 2], 
              Subscript[ A, 2]],
            Editable->False], "\[Rule]", 
          RowBox[{
            RowBox[{"-", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]B\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ B, 2]],
                  Editable->False], ")"}]}], "-", 
            \(\(I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\)\ \[Delta]\ \[Sigma]\ 
                  A\_1\%2\)\/\(4\ \[Omega]\_2\%2\)\), "-", 
            \(\(I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\)\ \[Delta]\ A\_1\ 
                  B\_1\)\/\[Omega]\_2\), "-", 
            \(\(I\ \[Delta]\^2\ A\_1\ A\_2\ A\&_\_1\)\/\(2\ \[Omega]\_1\ 
                  \[Omega]\_2\%2\)\), "+", 
            \(\(2\ I\ \[Delta]\^2\ A\_1\ A\_2\ A\&_\_1\)\/\(\[Omega]\_2\ 
                  \((2\ \[Omega]\_1\ \[Omega]\_2 + \[Omega]\_2\%2)
                    \)\)\)}]}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reconstitution", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using ",
  StyleBox["SCond1Rule1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["SCond2Rule1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we reconstitute the modulation equations as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(moduEq = 
      Table[2\ I\ \[Omega]\_k\ A\_k\^\[Prime], {k, 2}] == 
          \((\(\(Table[
                      2\ I\ \[Omega]\_k\ \(dt[1]\)[\ A\_k[T\_1, T\_2]], {k, 
                        2}] /. SCond1Rule1\) /. SCond2Rule1 // Expand\) // 
              Collect[#, \[Epsilon]]&)\) // Thread; \n
    moduEq /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_1\), " ", 
            SubsuperscriptBox["A", "1", "\[Prime]",
              MultilineFunction->None]}], "==", 
          RowBox[{
          \(2\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[Epsilon]\ A\_2\ 
              A\&_\_1\), "+", 
            RowBox[{\(\[Epsilon]\^2\), " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{\(-2\), " ", "I", " ", 
                    RowBox[{"(", 
                      InterpretationBox[\(D\_1\[InvisibleSpace]B\_1\),
                        SequenceForm[ 
                          Subscript[ D, 1], 
                          Subscript[ B, 1]],
                        Editable->False], ")"}], " ", \(\[Omega]\_1\)}], "+", 
                  \(2\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ B\_2\ A\&_\_1\), 
                  "-", \(\(E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[Sigma]\ 
                        A\_2\ A\&_\_1\)\/\[Omega]\_1\), "+", 
                  \(\(4\ \[Delta]\^2\ A\_1\%2\ A\&_\_1\)\/\[Omega]\_2\%2\), 
                  "+", \(\(\[Delta]\^2\ A\_1\%2\ A\&_\_1\)\/\(2\ \[Omega]\_1\ 
                        \[Omega]\_2\)\), "-", 
                  \(\(\[Delta]\^2\ A\_1\ A\_2\ A\&_\_2\)\/\[Omega]\_1\%2\), 
                  "-", \(\(4\ \[Delta]\^2\ A\_1\ A\_2\ 
                        A\&_\_2\)\/\(2\ \[Omega]\_1\ \[Omega]\_2 + 
                        \[Omega]\_2\%2\)\), "+", 
                  \(2\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ A\_2\ B\&_\_1\)}], 
                ")"}]}]}]}], ",", 
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_2\), " ", 
            SubsuperscriptBox["A", "2", "\[Prime]",
              MultilineFunction->None]}], "==", 
          RowBox[{
          \(E\^\(\(-I\)\ T\_1\ \[Sigma]\)\ \[Delta]\ \[Epsilon]\ A\_1\%2\), 
            "+", 
            RowBox[{\(\[Epsilon]\^2\), " ", 
              RowBox[{"(", 
                RowBox[{
                \(2\ E\^\(\(-I\)\ T\_1\ \[Sigma]\)\ \[Delta]\ A\_1\ B\_1\), 
                  "+", \(\(E\^\(\(-I\)\ T\_1\ \[Sigma]\)\ \[Delta]\ \[Sigma]\ 
                        A\_1\%2\)\/\(2\ \[Omega]\_2\)\), "-", 
                  RowBox[{"2", " ", "I", " ", 
                    RowBox[{"(", 
                      InterpretationBox[\(D\_1\[InvisibleSpace]B\_2\),
                        SequenceForm[ 
                          Subscript[ D, 1], 
                          Subscript[ B, 2]],
                        Editable->False], ")"}], " ", \(\[Omega]\_2\)}], "+", 
                  \(\(\[Delta]\^2\ A\_1\ A\_2\ A\&_\_1\)\/\(\[Omega]\_1\ 
                        \[Omega]\_2\)\), "-", 
                  \(\(4\ \[Delta]\^2\ A\_1\ A\_2\ 
                        A\&_\_1\)\/\(2\ \[Omega]\_1\ \[Omega]\_2 + 
                        \[Omega]\_2\%2\)\)}], ")"}]}]}]}]}], "}"}]], "Output",\

  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Without including the ",
  Cell[BoxData[
      \(TraditionalForm\`B\_i\)]],
  " in the second-order solution, the following two coefficients:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(Coefficient[moduEq[\([1, 2]\)], 
          A\_1[T\_1, T\_2]\ A\_2[T\_1, T\_2]\ A\&_\_2[T\_1, T\_2]] /. 
        \[Omega]\_2 -> 2\ \[Omega]\_1 // Simplify\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(-\(\(3\ \[Delta]\^2\ \[Epsilon]\^2\)\/\(2\ \[Omega]\_1\%2\)\)\)\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Coefficient[moduEq[\([2, 2]\)], 
          A\_1[T\_1, T\_2]\ A\_2[T\_1, T\_2]\ A\&_\_1[T\_1, T\_2]] /. 
        \[Omega]\_2 -> 2\ \[Omega]\_1 // Simplify\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(0\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "are not the same, which violates the conservative nature of the system in \
that the modulation equations must be derivable from a Lagrangian. Using the \
flexibility given by the homogeneous parts of the solutions of the \
second-order problem, we choose the functions ",
  Cell[BoxData[
      \(TraditionalForm\`B\_i[t]\)]],
  " so that these coefficients are the same. To this end, we assume that"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(BForm = {
        B\_1 -> Function[{T\_1, T\_2}, 
            c\_1\ E\^\(I\ T\_1\ \[Sigma]\)\ A\&_\_1[T\_1, T\_2]\ 
              A\_2[T\_1, T\_2]\ ], 
        B\&_\_1 -> 
          Function[{T\_1, T\_2}, 
            c\_1\ E\^\(\(-I\)\ T\_1\ \[Sigma]\)\ A\_1[T\_1, T\_2]\ 
              A\&_\_2[T\_1, T\_2]\ ], 
        B\_2 -> Function[{T\_1, T\_2}, 
            c\_2\ E\^\(\(-I\)\ T\_1\ \[Sigma]\)\ A\_1[T\_1, T\_2]\^2\ ]}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`c\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`c\_2\)]],
  " are undetermined constants. Substituting ",
  StyleBox["BForm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and the solvability conditions into the right-hand sides of ",
  StyleBox["moduEq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(moduEqMod = 
      \((\(Expand[\(\(# /. BForm\) /. SCond1Rule1\) /. ccSCond1Rule1]\ &\)\ /@
            \ moduEq)\) // ExpandAll; \nmoduEqMod /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_1\), " ", 
            SubsuperscriptBox["A", "1", "\[Prime]",
              MultilineFunction->None]}], "==", 
          \(2\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[Epsilon]\ A\_2\ 
              A\&_\_1 + 2\ \[Delta]\ \[Epsilon]\^2\ A\_1\%2\ c\_2\ A\&_\_1 - 
            \(E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[Epsilon]\^2\ \[Sigma]\ 
                A\_2\ A\&_\_1\)\/\[Omega]\_1 + 
            2\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Epsilon]\^2\ \[Sigma]\ A\_2\ c\_1\ 
              \[Omega]\_1\ A\&_\_1 + 
            \(4\ \[Delta]\^2\ \[Epsilon]\^2\ A\_1\%2\ A\&_\_1\)\/\[Omega]\_2
                \%2 + \(\[Delta]\^2\ \[Epsilon]\^2\ A\_1\%2\ A\&_\_1\)\/\(2\ 
                \[Omega]\_1\ \[Omega]\_2\) - 
            \(\[Delta]\ \[Epsilon]\^2\ A\_1\%2\ c\_1\ \[Omega]\_1\ 
                A\&_\_1\)\/\[Omega]\_2 + 
            4\ \[Delta]\ \[Epsilon]\^2\ A\_1\ A\_2\ c\_1\ A\&_\_2 - 
            \(\[Delta]\^2\ \[Epsilon]\^2\ A\_1\ A\_2\ A\&_\_2\)\/\[Omega]\_1
                \%2 - \(4\ \[Delta]\^2\ \[Epsilon]\^2\ A\_1\ A\_2\ 
                A\&_\_2\)\/\(2\ \[Omega]\_1\ \[Omega]\_2 + 
                \[Omega]\_2\%2\)\)}], ",", 
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_2\), " ", 
            SubsuperscriptBox["A", "2", "\[Prime]",
              MultilineFunction->None]}], "==", 
          \(E\^\(\(-I\)\ T\_1\ \[Sigma]\)\ \[Delta]\ \[Epsilon]\ A\_1\%2 + 
            \(E\^\(\(-I\)\ T\_1\ \[Sigma]\)\ \[Delta]\ \[Epsilon]\^2\ 
                \[Sigma]\ A\_1\%2\)\/\(2\ \[Omega]\_2\) - 
            2\ E\^\(\(-I\)\ T\_1\ \[Sigma]\)\ \[Epsilon]\^2\ \[Sigma]\ 
              A\_1\%2\ c\_2\ \[Omega]\_2 + 
            2\ \[Delta]\ \[Epsilon]\^2\ A\_1\ A\_2\ c\_1\ A\&_\_1 + 
            \(\[Delta]\^2\ \[Epsilon]\^2\ A\_1\ A\_2\ 
                A\&_\_1\)\/\(\[Omega]\_1\ \[Omega]\_2\) - 
            \(4\ \[Delta]\ \[Epsilon]\^2\ A\_1\ A\_2\ c\_2\ \[Omega]\_2\ 
                A\&_\_1\)\/\[Omega]\_1 - 
            \(4\ \[Delta]\^2\ \[Epsilon]\^2\ A\_1\ A\_2\ 
                A\&_\_1\)\/\(2\ \[Omega]\_1\ \[Omega]\_2 + 
                \[Omega]\_2\%2\)\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "In order that the ",
  StyleBox["moduEqMod",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " be derivable from a Lagrangian, the following condition must be \
satisfied:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Coefficient[moduEqMod[\([1, 2]\)], 
              A\_1[T\_1, T\_2]\ A\_2[T\_1, T\_2]\ A\&_\_2[T\_1, T\_2]] - 
            Coefficient[moduEqMod[\([2, 2]\)], 
              A\_1[T\_1, T\_2]\ A\_2[T\_1, T\_2]\ A\&_\_1[T\_1, T\_2]] == 
          0 /. \[Epsilon] -> 1\) /. \[Omega]\_2 -> 2  \[Omega]\_1\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(2\ \[Delta]\ c\_1 + 8\ \[Delta]\ c\_2 - 
        \(3\ \[Delta]\^2\)\/\(2\ \[Omega]\_1\%2\) == 0\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
This provides a compatibility condition. However, one extra constant is \
floating !!!\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "To obtain a consistent second-order uniform expansion, we apply the method \
of multiple scales to the system of four first-order real-valued equations ",
  StyleBox["EOM2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  StyleBox[" ",
    FontColor->RGBColor[1, 0, 1]],
  "in Section 5.2.2 and to a system of two first-order complex-valued \
equations in Section 5.2.3."
}], "Text",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["5.2.2 First-Order Real-Valued System", "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "As shown in the preceding section, treating the second-order form of the \
equations governing a system may lead to inconsistent results unless \
appropriate parts of the homogeneous solutions of the perturbation equations \
are included. Moreover, the consistent expansions might contain arbitrary \
constants that need to be chosen judiciously. In this section, we show that \
treatment of an equivalent set of first-order real-valued equations, namely ",
  
  StyleBox["EOM2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", leads to consistent results without floating constants."
}], "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "We seek a second-order uniform expansion of the solution of ",
  StyleBox["EOM2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in the form"
}], "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(solRule = {
        u\_i_ -> 
          \((Sum[\[Epsilon]\^j\ u\_\(i, j\)[#1, #2, #3], {j, 3}]\ &)\), 
        v\_i_ -> 
          \((Sum[\[Epsilon]\^j\ v\_\(i, j\)[#1, #2, #3], {j, 3}]\ &)\)}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Expressing the time derivative in ",
  StyleBox["EOM2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in terms of the time scales ",
  Cell[BoxData[
      \(TraditionalForm\`T\_0, T\_1, \)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`T\_2\)]],
  ", we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(multiScales = {u_\_i_[t] -> u\_i[T\_0, T\_1, T\_2], 
        \(\(Derivative[n_]\)[u_\_i_]\)[t] :> 
          \(dt[n]\)[u\_i[T\_0, T\_1, T\_2]]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["multiScales",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["solRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["EOM2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", expanding the result for small \[Epsilon], and discarding terms of order \
higher than ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon]\^3\)]],
  ", we obtain"
}], "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eq522a = 
      \((\(EOM2 /. multiScales\) /. solRule // ExpandAll)\) /. 
        \[Epsilon]\^\(n_ /; n > 3\) -> 0; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[
"Equating coefficients of like powers of \[Epsilon], we obtain"], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eqEps = 
      \(Rest[Thread[CoefficientList[Subtract\ @@\ #, \[Epsilon]] == 0]]&\)\ /@
          \ eq522a // Transpose; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
To place the linear operators on one side and the nonhomogeneous terms on the \
other side, we define\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(eqOrder[i_] := 
      \((\(#[\([1]\)]\ &\)\ /@\ eqEps[\([1]\)] /. 
              u_\_\(k_, 1\) -> u\_\(k, i\))\) == 
          \((\(#[\([1]\)]\ &\)\ /@\ eqEps[\([1]\)] /. 
                u_\_\(k_, 1\) -> u\_\(k, i\))\) - 
            \((\(#[\([1]\)]\ &\)\ /@\ eqEps[\([i]\)])\) // Thread\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using ",
  StyleBox["eqOrder[i]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["displayRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we rewrite ",
  StyleBox["eqEps",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in a concise way as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[{
    \(eqOrder[1] /. displayRule // TableForm\), 
    \(eqOrder[2] /. displayRule // TableForm\), 
    \(eqOrder[3] /. displayRule // TableForm\)}], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]u\_\(1, 1\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ u, 1, 1]],
                  Editable->False], "-", \(v\_\(1, 1\)\)}], "==", "0"}]},
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(1, 1\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ v, 1, 1]],
                  Editable->False], "+", \(\[Omega]\_1\%2\ u\_\(1, 1\)\)}], 
              "==", "0"}]},
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]u\_\(2, 1\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ u, 2, 1]],
                  Editable->False], "-", \(v\_\(2, 1\)\)}], "==", "0"}]},
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 1\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ v, 2, 1]],
                  Editable->False], "+", \(\[Omega]\_2\%2\ u\_\(2, 1\)\)}], 
              "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ u, 1, 1]], 
            Times[ -1, 
              Subscript[ v, 1, 1]]], 0], 
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ v, 1, 1]], 
            Times[ 
              Power[ 
                Subscript[ \[Omega], 1], 2], 
              Subscript[ u, 1, 1]]], 0], 
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ u, 2, 1]], 
            Times[ -1, 
              Subscript[ v, 2, 1]]], 0], 
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ v, 2, 1]], 
            Times[ 
              Power[ 
                Subscript[ \[Omega], 2], 2], 
              Subscript[ u, 2, 1]]], 0]}]]], "Output",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]u\_\(1, 2\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ u, 1, 2]],
                  Editable->False], "-", \(v\_\(1, 2\)\)}], "==", 
              RowBox[{"-", 
                RowBox[{"(", 
                  InterpretationBox[\(D\_1\[InvisibleSpace]u\_\(1, 1\)\),
                    SequenceForm[ 
                      Subscript[ D, 1], 
                      Subscript[ u, 1, 1]],
                    Editable->False], ")"}]}]}]},
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(1, 2\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ v, 1, 2]],
                  Editable->False], "+", \(\[Omega]\_1\%2\ u\_\(1, 2\)\)}], 
              "==", 
              RowBox[{
                RowBox[{"-", 
                  RowBox[{"(", 
                    InterpretationBox[\(D\_1\[InvisibleSpace]v\_\(1, 1\)\),
                      SequenceForm[ 
                        Subscript[ D, 1], 
                        Subscript[ v, 1, 1]],
                      Editable->False], ")"}]}], "+", 
                \(2\ \[Delta]\ u\_\(1, 1\)\ u\_\(2, 1\)\)}]}]},
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]u\_\(2, 2\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ u, 2, 2]],
                  Editable->False], "-", \(v\_\(2, 2\)\)}], "==", 
              RowBox[{"-", 
                RowBox[{"(", 
                  InterpretationBox[\(D\_1\[InvisibleSpace]u\_\(2, 1\)\),
                    SequenceForm[ 
                      Subscript[ D, 1], 
                      Subscript[ u, 2, 1]],
                    Editable->False], ")"}]}]}]},
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 2\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ v, 2, 2]],
                  Editable->False], "+", \(\[Omega]\_2\%2\ u\_\(2, 2\)\)}], 
              "==", 
              RowBox[{
                RowBox[{"-", 
                  RowBox[{"(", 
                    InterpretationBox[\(D\_1\[InvisibleSpace]v\_\(2, 1\)\),
                      SequenceForm[ 
                        Subscript[ D, 1], 
                        Subscript[ v, 2, 1]],
                      Editable->False], ")"}]}], "+", 
                \(\[Delta]\ u\_\(1, 1\)\%2\)}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ u, 1, 2]], 
            Times[ -1, 
              Subscript[ v, 1, 2]]], 
          Times[ -1, 
            SequenceForm[ 
              Subscript[ D, 1], 
              Subscript[ u, 1, 1]]]], 
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ v, 1, 2]], 
            Times[ 
              Power[ 
                Subscript[ \[Omega], 1], 2], 
              Subscript[ u, 1, 2]]], 
          Plus[ 
            Times[ -1, 
              SequenceForm[ 
                Subscript[ D, 1], 
                Subscript[ v, 1, 1]]], 
            Times[ 2, \[Delta], 
              Subscript[ u, 1, 1], 
              Subscript[ u, 2, 1]]]], 
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ u, 2, 2]], 
            Times[ -1, 
              Subscript[ v, 2, 2]]], 
          Times[ -1, 
            SequenceForm[ 
              Subscript[ D, 1], 
              Subscript[ u, 2, 1]]]], 
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ v, 2, 2]], 
            Times[ 
              Power[ 
                Subscript[ \[Omega], 2], 2], 
              Subscript[ u, 2, 2]]], 
          Plus[ 
            Times[ -1, 
              SequenceForm[ 
                Subscript[ D, 1], 
                Subscript[ v, 2, 1]]], 
            Times[ \[Delta], 
              Power[ 
                Subscript[ u, 1, 1], 2]]]]}]]], "Output",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]u\_\(1, 3\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ u, 1, 3]],
                  Editable->False], "-", \(v\_\(1, 3\)\)}], "==", 
              RowBox[{
                RowBox[{"-", 
                  RowBox[{"(", 
                    InterpretationBox[\(D\_1\[InvisibleSpace]u\_\(1, 2\)\),
                      SequenceForm[ 
                        Subscript[ D, 1], 
                        Subscript[ u, 1, 2]],
                      Editable->False], ")"}]}], "-", 
                InterpretationBox[\(D\_2\[InvisibleSpace]u\_\(1, 1\)\),
                  SequenceForm[ 
                    Subscript[ D, 2], 
                    Subscript[ u, 1, 1]],
                  Editable->False]}]}]},
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(1, 3\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ v, 1, 3]],
                  Editable->False], "+", \(\[Omega]\_1\%2\ u\_\(1, 3\)\)}], 
              "==", 
              RowBox[{
                RowBox[{"-", 
                  RowBox[{"(", 
                    InterpretationBox[\(D\_1\[InvisibleSpace]v\_\(1, 2\)\),
                      SequenceForm[ 
                        Subscript[ D, 1], 
                        Subscript[ v, 1, 2]],
                      Editable->False], ")"}]}], "-", 
                InterpretationBox[\(D\_2\[InvisibleSpace]v\_\(1, 1\)\),
                  SequenceForm[ 
                    Subscript[ D, 2], 
                    Subscript[ v, 1, 1]],
                  Editable->False], "+", 
                \(2\ \[Delta]\ u\_\(1, 2\)\ u\_\(2, 1\)\), "+", 
                \(2\ \[Delta]\ u\_\(1, 1\)\ u\_\(2, 2\)\)}]}]},
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]u\_\(2, 3\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ u, 2, 3]],
                  Editable->False], "-", \(v\_\(2, 3\)\)}], "==", 
              RowBox[{
                RowBox[{"-", 
                  RowBox[{"(", 
                    InterpretationBox[\(D\_1\[InvisibleSpace]u\_\(2, 2\)\),
                      SequenceForm[ 
                        Subscript[ D, 1], 
                        Subscript[ u, 2, 2]],
                      Editable->False], ")"}]}], "-", 
                InterpretationBox[\(D\_2\[InvisibleSpace]u\_\(2, 1\)\),
                  SequenceForm[ 
                    Subscript[ D, 2], 
                    Subscript[ u, 2, 1]],
                  Editable->False]}]}]},
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 3\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ v, 2, 3]],
                  Editable->False], "+", \(\[Omega]\_2\%2\ u\_\(2, 3\)\)}], 
              "==", 
              RowBox[{
                RowBox[{"-", 
                  RowBox[{"(", 
                    InterpretationBox[\(D\_1\[InvisibleSpace]v\_\(2, 2\)\),
                      SequenceForm[ 
                        Subscript[ D, 1], 
                        Subscript[ v, 2, 2]],
                      Editable->False], ")"}]}], "-", 
                InterpretationBox[\(D\_2\[InvisibleSpace]v\_\(2, 1\)\),
                  SequenceForm[ 
                    Subscript[ D, 2], 
                    Subscript[ v, 2, 1]],
                  Editable->False], "+", 
                \(2\ \[Delta]\ u\_\(1, 1\)\ u\_\(1, 2\)\)}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ u, 1, 3]], 
            Times[ -1, 
              Subscript[ v, 1, 3]]], 
          Plus[ 
            Times[ -1, 
              SequenceForm[ 
                Subscript[ D, 1], 
                Subscript[ u, 1, 2]]], 
            Times[ -1, 
              SequenceForm[ 
                Subscript[ D, 2], 
                Subscript[ u, 1, 1]]]]], 
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ v, 1, 3]], 
            Times[ 
              Power[ 
                Subscript[ \[Omega], 1], 2], 
              Subscript[ u, 1, 3]]], 
          Plus[ 
            Times[ -1, 
              SequenceForm[ 
                Subscript[ D, 1], 
                Subscript[ v, 1, 2]]], 
            Times[ -1, 
              SequenceForm[ 
                Subscript[ D, 2], 
                Subscript[ v, 1, 1]]], 
            Times[ 2, \[Delta], 
              Subscript[ u, 1, 2], 
              Subscript[ u, 2, 1]], 
            Times[ 2, \[Delta], 
              Subscript[ u, 1, 1], 
              Subscript[ u, 2, 2]]]], 
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ u, 2, 3]], 
            Times[ -1, 
              Subscript[ v, 2, 3]]], 
          Plus[ 
            Times[ -1, 
              SequenceForm[ 
                Subscript[ D, 1], 
                Subscript[ u, 2, 2]]], 
            Times[ -1, 
              SequenceForm[ 
                Subscript[ D, 2], 
                Subscript[ u, 2, 1]]]]], 
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ v, 2, 3]], 
            Times[ 
              Power[ 
                Subscript[ \[Omega], 2], 2], 
              Subscript[ u, 2, 3]]], 
          Plus[ 
            Times[ -1, 
              SequenceForm[ 
                Subscript[ D, 1], 
                Subscript[ v, 2, 2]]], 
            Times[ -1, 
              SequenceForm[ 
                Subscript[ D, 2], 
                Subscript[ v, 2, 1]]], 
            Times[ 2, \[Delta], 
              Subscript[ u, 1, 1], 
              Subscript[ u, 1, 2]]]]}]]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell["First-Order Equations", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "The homogeneous solution of ",
  StyleBox["eqOrder[1]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " can be obtained by using"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eigenForm = 
      \(#[\([2]\)]\ Exp[#[\([1]\)]\ T\_0]\ &\)\ /@\ 
        Transpose[Eigensystem[matrixA]]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{\(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\)\/\[Omega]\_1, 
        E\^\(\(-I\)\ T\_0\ \[Omega]\_1\), 0, 0}, {
        \(-\(\(I\ E\^\(I\ T\_0\ \[Omega]\_1\)\)\/\[Omega]\_1\)\), 
        E\^\(I\ T\_0\ \[Omega]\_1\), 0, 0}, {0, 0, 
        \(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\)\/\[Omega]\_2, 
        E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)}, {0, 0, 
        \(-\(\(I\ E\^\(I\ T\_0\ \[Omega]\_2\)\)\/\[Omega]\_2\)\), 
        E\^\(I\ T\_0\ \[Omega]\_2\)}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1hForm = 
      Flatten[Table[
            I\ \(\[Omega]\_i\) {\(-A\&_\_i[T\_1, T\_2]\), A\_i[T\_1, T\_2]}, {
              i, 2}]] . eigenForm\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1[T\_1, T\_2] + 
        E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ A\&_\_1[T\_1, T\_2], 
      I\ E\^\(I\ T\_0\ \[Omega]\_1\)\ \[Omega]\_1\ A\_1[T\_1, T\_2] - 
        I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ \[Omega]\_1\ 
          A\&_\_1[T\_1, T\_2], 
      E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2[T\_1, T\_2] + 
        E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ A\&_\_2[T\_1, T\_2], 
      I\ E\^\(I\ T\_0\ \[Omega]\_2\)\ \[Omega]\_2\ A\_2[T\_1, T\_2] - 
        I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ \[Omega]\_2\ A\&_\_2[T\_1, T\_2]}
      \)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Since the first-order equations are homogeneous, the solution of ",
  StyleBox["eqOrder[1]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " can be expressed as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(states1 = {u\_\(1, 1\), v\_\(1, 1\), u\_\(2, 1\), v\_\(2, 1\)}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1 = 
      Table[states1[\([i]\)] -> 
          Function[{T\_0, T\_1, T\_2}, sol1hForm[\([i]\)] // Evaluate], {i, 
          4}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_\(1, 1\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1[T\_1, T\_2] + 
            E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ A\&_\_1[T\_1, T\_2]], 
      v\_\(1, 1\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          I\ E\^\(I\ T\_0\ \[Omega]\_1\)\ \[Omega]\_1\ A\_1[T\_1, T\_2] - 
            I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ \[Omega]\_1\ 
              A\&_\_1[T\_1, T\_2]], 
      u\_\(2, 1\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2[T\_1, T\_2] + 
            E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ A\&_\_2[T\_1, T\_2]], 
      v\_\(2, 1\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          I\ E\^\(I\ T\_0\ \[Omega]\_2\)\ \[Omega]\_2\ A\_2[T\_1, T\_2] - 
            I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ \[Omega]\_2\ 
              A\&_\_2[T\_1, T\_2]]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Second-Order Equations", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting the first-order solution into the second-order equations, ",
  StyleBox["eqOrder[2]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order2Eq = eqOrder[2] /. sol1 // ExpandAll; \n
    order2Eq /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]u\_\(1, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ u, 1, 2]],
              Editable->False], "-", \(v\_\(1, 2\)\)}], "==", 
          RowBox[{
            RowBox[{\(-E\^\(I\ T\_0\ \[Omega]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}]}], "-", 
            RowBox[{\(E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 1]],
                  Editable->False], ")"}]}]}]}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(1, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 1, 2]],
              Editable->False], "+", \(\[Omega]\_1\%2\ u\_\(1, 2\)\)}], 
          "==", 
          RowBox[{
          \(2\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ \[Delta]\ 
              A\_1\ A\_2\), "-", 
            RowBox[{"I", " ", \(E\^\(I\ T\_0\ \[Omega]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}], " ", \(\[Omega]\_1\)}], "+", 
            RowBox[{"I", " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 1]],
                  Editable->False], ")"}], " ", \(\[Omega]\_1\)}], "+", 
            \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
              \[Delta]\ A\_2\ A\&_\_1\), "+", 
            \(2\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
              \[Delta]\ A\_1\ A\&_\_2\), "+", 
            \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
              \[Delta]\ A\&_\_1\ A\&_\_2\)}]}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]u\_\(2, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ u, 2, 2]],
              Editable->False], "-", \(v\_\(2, 2\)\)}], "==", 
          RowBox[{
            RowBox[{\(-E\^\(I\ T\_0\ \[Omega]\_2\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}]}], "-", 
            RowBox[{\(E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 2]],
                  Editable->False], ")"}]}]}]}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 2, 2]],
              Editable->False], "+", \(\[Omega]\_2\%2\ u\_\(2, 2\)\)}], 
          "==", 
          RowBox[{
          \(E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\ A\_1\%2\), "-", 
            RowBox[{"I", " ", \(E\^\(I\ T\_0\ \[Omega]\_2\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}], " ", \(\[Omega]\_2\)}], "+", 
            RowBox[{"I", " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 2]],
                  Editable->False], ")"}], " ", \(\[Omega]\_2\)}], "+", 
            \(2\ \[Delta]\ A\_1\ A\&_\_1\), "+", 
            \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\ 
              A\&_\_1\%2\)}]}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Next, we substitute the ",
  StyleBox["expRule1[i]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into the right-hand sides of ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " to transform the small-divisor terms into secular terms, collect the \
terms responsible for secular terms, and obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(ST11 = 
      \(Coefficient[#[\([2]\)] /. expRule1[1], Exp[I\ \[Omega]\_1\ T\_0]]\ &
          \)\ /@\ order2Eq; \nST11 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"-", 
          RowBox[{"(", 
            InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
              SequenceForm[ 
                Subscript[ D, 1], 
                Subscript[ A, 1]],
              Editable->False], ")"}]}], ",", 
        RowBox[{
          RowBox[{\(-I\), " ", 
            RowBox[{"(", 
              InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                SequenceForm[ 
                  Subscript[ D, 1], 
                  Subscript[ A, 1]],
                Editable->False], ")"}], " ", \(\[Omega]\_1\)}], "+", 
          \(2\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ A\_2\ A\&_\_1\)}], ",", 
        "0", ",", "0"}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ST12 = 
      \(Coefficient[#[\([2]\)] /. expRule1[2], Exp[I\ \[Omega]\_2\ T\_0]]\ &
          \)\ /@\ order2Eq; \nST12 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
        RowBox[{"-", 
          RowBox[{"(", 
            InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
              SequenceForm[ 
                Subscript[ D, 1], 
                Subscript[ A, 2]],
              Editable->False], ")"}]}], ",", 
        RowBox[{\(E\^\(\(-I\)\ T\_1\ \[Sigma]\)\ \[Delta]\ A\_1\%2\), "-", 
          RowBox[{"I", " ", 
            RowBox[{"(", 
              InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                SequenceForm[ 
                  Subscript[ D, 1], 
                  Subscript[ A, 2]],
                Editable->False], ")"}], " ", \(\[Omega]\_2\)}]}]}], "}"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The solvability conditions of the second-order equations demands that ",
  StyleBox["ST11",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["ST12",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " be orthogonal to every solution of the adjoint homogeneous problems, \
namely the components of ",
  StyleBox["ccleftVec",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ". Imposing these conditions, we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(SCond1 = {ccleftVec[\([1]\)] . ST11 == 0, 
        ccleftVec[\([2]\)] . ST12 == 0}; \nSCond1 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{\(-2\), " ", "I", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}], " ", \(\[Omega]\_1\)}], "+", 
            \(2\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ A\_2\ A\&_\_1\)}], "==", 
          "0"}], ",", 
        RowBox[{
          RowBox[{\(E\^\(\(-I\)\ T\_1\ \[Sigma]\)\ \[Delta]\ A\_1\%2\), "-", 
            RowBox[{"2", " ", "I", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}], " ", \(\[Omega]\_2\)}]}], "==", 
          "0"}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["or", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"SCond1Rule1", "=", 
        RowBox[{
          RowBox[{"Solve", "[", 
            RowBox[{"SCond1", ",", 
              RowBox[{"{", 
                RowBox[{
                  RowBox[{
                    SubsuperscriptBox["A", "1", 
                      TagBox[\((1, 0)\),
                        Derivative],
                      MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}], 
                  ",", 
                  RowBox[{
                    SubsuperscriptBox["A", "2", 
                      TagBox[\((1, 0)\),
                        Derivative],
                      MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], 
                "}"}]}], "]"}], "[", \([1]\), "]"}]}], ";", "\n", 
      \(SCond1Rule1 /. displayRule\)}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
            SequenceForm[ 
              Subscript[ D, 1], 
              Subscript[ A, 1]],
            Editable->False], "\[Rule]", 
          \(-\(\(I\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ A\_2\ 
                  A\&_\_1\)\/\[Omega]\_1\)\)}], ",", 
        RowBox[{
          InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
            SequenceForm[ 
              Subscript[ D, 1], 
              Subscript[ A, 2]],
            Editable->False], "\[Rule]", 
          \(-\(\(I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\)\ \[Delta]\ A\_1\%2\)\/\(2\ 
                  \[Omega]\_2\)\)\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["whose complex conjugate is", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ccSCond1Rule1 = SCond1Rule1 /. conjugateRule; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using these solvability conditions and ",
  StyleBox["expRule3",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we rewrite ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order2Eqm = 
      \(\(order2Eq /. SCond1Rule1\) /. ccSCond1Rule1\) /. expRule3; \n
    order2Eqm /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]u\_\(1, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ u, 1, 2]],
              Editable->False], "-", \(v\_\(1, 2\)\)}], "==", 
          \(\(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\ A\_2\ A\&_\_1\)\/\[Omega]\_1 - 
            \(I\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\ A\_1\ A\&_\_2\)\/\[Omega]\_1\)}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(1, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 1, 2]],
              Editable->False], "+", \(\[Omega]\_1\%2\ u\_\(1, 2\)\)}], "==", 
          \(2\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ \[Delta]\ 
              A\_1\ A\_2 + 
            E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
              \[Delta]\ A\_2\ A\&_\_1 + 
            E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ \[Delta]\ 
              A\_1\ A\&_\_2 + 
            2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
              \[Delta]\ A\&_\_1\ A\&_\_2\)}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]u\_\(2, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ u, 2, 2]],
              Editable->False], "-", \(v\_\(2, 2\)\)}], "==", 
          \(\(I\ E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\ A\_1\%2\)\/\(2\ 
                \[Omega]\_2\) - 
            \(I\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\ 
                A\&_\_1\%2\)\/\(2\ \[Omega]\_2\)\)}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_\(2, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 2, 2]],
              Editable->False], "+", \(\[Omega]\_2\%2\ u\_\(2, 2\)\)}], "==", 
          \(1\/2\ E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\ A\_1\%2 + 
            2\ \[Delta]\ A\_1\ A\&_\_1 + 
            1\/2\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\ 
              A\&_\_1\%2\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Transforming ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into a set of ordinary-differential equations and using ",
  StyleBox["DSolve",
    FontWeight->"Bold"],
  ", we obtain the particular solutions as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((sol2p = 
          \(DSolve[
                  order2Eqm /. u_\_\(i_, 2\) -> \((u\_\(i, 2\)[#1]\ &)\), {
                    u\_\(1, 2\)[T\_0], v\_\(1, 2\)[T\_0], u\_\(2, 2\)[T\_0], 
                    v\_\(2, 2\)[T\_0]}, T\_0]\)[\([1]\)] /. C[_] -> 0 // 
            Simplify; )\) // Timing\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({13.1389999999992146`\ Second, Null}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Hence, the second-order solutions of ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " can be expressed as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(states2 = states1 /. u_\_\(i_, 1\) -> u\_\(i, 2\)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_\(1, 2\), v\_\(1, 2\), u\_\(2, 2\), v\_\(2, 2\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2 = 
      Table[states2[\([i]\)] -> 
          Function[{T\_0, T\_1, T\_2}, 
            Expand[sol2p[\([i, 2]\)]] /. Exp[a_] :> Exp[a // Expand] // 
              Evaluate], {i, 4}]; \nsol2 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_\(1, 2\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          \(-\(\(2\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    \[Delta]\ A\_1\ A\_2\)\/\(\[Omega]\_2\ 
                    \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)\) + 
            \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\ A\_2\ A\&_\_1\)\/\(\[Omega]\_1\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
            \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\ A\_2\ A\&_\_1\)\/\(\[Omega]\_2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
            \(E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ \[Delta]\ 
                A\_1\ A\&_\_2\)\/\(\[Omega]\_1\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
            \(2\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\ A\_1\ A\&_\_2\)\/\(\[Omega]\_2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) - 
            \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\ A\&_\_1\ A\&_\_2\)\/\(\[Omega]\_2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)], 
      v\_\(1, 2\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          \(-\(\(2\ I\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    \[Delta]\ A\_1\ A\_2\)\/\(2\ \[Omega]\_1 + 
                    \[Omega]\_2\)\)\) - 
            \(2\ I\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\ \[Omega]\_1\ A\_1\ A\_2\)\/\(\[Omega]\_2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) - 
            \(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\ A\_2\ A\&_\_1\)\/\(2\ \[Omega]\_1 + \[Omega]\_2\) - 
            \(2\ I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\ \[Omega]\_1\ A\_2\ A\&_\_1\)\/\(\[Omega]\_2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
            \(I\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\ A\_1\ A\&_\_2\)\/\(2\ \[Omega]\_1 + \[Omega]\_2\) + 
            \(2\ I\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\ \[Omega]\_1\ A\_1\ A\&_\_2\)\/\(\[Omega]\_2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
            \(2\ I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\ A\&_\_1\ A\&_\_2\)\/\(2\ \[Omega]\_1 + 
                \[Omega]\_2\) + 
            \(2\ I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\ \[Omega]\_1\ A\&_\_1\ A\&_\_2\)\/\(\[Omega]\_2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)], 
      u\_\(2, 2\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          \(E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\ A\_1\%2\)\/\(2\ 
                \[Omega]\_2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
            \(4\ \[Delta]\ \[Omega]\_1\ A\_1\ A\&_\_1\)\/\(\[Omega]\_2\%2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
            \(2\ \[Delta]\ A\_1\ A\&_\_1\)\/\(\[Omega]\_2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
            \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\ A\&_\_1\%2\)\/\(2
                \ \[Omega]\_2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)], 
      v\_\(2, 2\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          \(-\(\(I\ E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\ A\_1\%2\)\/\(2\ 
                    \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)\) + 
            \(I\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\ 
                A\&_\_1\%2\)\/\(2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)]}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Third-Order Equations", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting the first- and second-order solutions into the right-hand \
sides of the third-order equations, ",
  StyleBox["eqOrder[3]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(order3Eqrhs = 
      \(Expand[\(#[\([2]\)] /. sol1\) /. sol2]\ &\)\ /@\ eqOrder[3]; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "To eliminate the terms that lead to secular terms from ",
  StyleBox["order3Eqrhs",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we use ",
  StyleBox["expRule1[i]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " to transform the terms that convert small-divisor terms into secular \
terms, calculate the vectors proportional to the ",
  Cell[BoxData[
      \(TraditionalForm\`\(E\^\(I\ \[Omega]\_i\ T\_0\), \)\)]],
  " and obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(ST21 = 
      Coefficient[order3Eqrhs /. expRule1[1], Exp[I\ \[Omega]\_1\ T\_0]]; \n
    ST21 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{"-", 
            RowBox[{"(", 
              InterpretationBox[\(D\_2\[InvisibleSpace]A\_1\),
                SequenceForm[ 
                  Subscript[ D, 2], 
                  Subscript[ A, 1]],
                Editable->False], ")"}]}], "-", 
          FractionBox[
            RowBox[{\(E\^\(I\ T\_1\ \[Sigma]\)\), " ", "\[Delta]", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 1]],
                  Editable->False], ")"}], " ", \(A\_2\)}], 
            \(\[Omega]\_1\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)], "-", 
          FractionBox[
            RowBox[{
            "2", " ", \(E\^\(I\ T\_1\ \[Sigma]\)\), " ", "\[Delta]", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 1]],
                  Editable->False], ")"}], " ", \(A\_2\)}], 
            \(\[Omega]\_2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)], "-", 
          FractionBox[
            RowBox[{\(E\^\(I\ T\_1\ \[Sigma]\)\), " ", "\[Delta]", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}], " ", \(A\&_\_1\)}], 
            \(\[Omega]\_1\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)], "-", 
          FractionBox[
            RowBox[{
            "2", " ", \(E\^\(I\ T\_1\ \[Sigma]\)\), " ", "\[Delta]", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}], " ", \(A\&_\_1\)}], 
            \(\[Omega]\_2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)]}], ",", 
        RowBox[{
          RowBox[{\(-I\), " ", 
            RowBox[{"(", 
              InterpretationBox[\(D\_2\[InvisibleSpace]A\_1\),
                SequenceForm[ 
                  Subscript[ D, 2], 
                  Subscript[ A, 1]],
                Editable->False], ")"}], " ", \(\[Omega]\_1\)}], "+", 
          FractionBox[
            RowBox[{
            "I", " ", \(E\^\(I\ T\_1\ \[Sigma]\)\), " ", "\[Delta]", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 1]],
                  Editable->False], ")"}], " ", \(A\_2\)}], 
            \(2\ \[Omega]\_1 + \[Omega]\_2\)], "+", 
          FractionBox[
            RowBox[{
            "2", " ", "I", " ", \(E\^\(I\ T\_1\ \[Sigma]\)\), " ", 
              "\[Delta]", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ 
                      OverBar[ A], 1]],
                  Editable->False], ")"}], " ", \(A\_2\), " ", 
              \(\[Omega]\_1\)}], 
            \(\[Omega]\_2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)], "+", 
          FractionBox[
            RowBox[{
            "I", " ", \(E\^\(I\ T\_1\ \[Sigma]\)\), " ", "\[Delta]", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}], " ", \(A\&_\_1\)}], 
            \(2\ \[Omega]\_1 + \[Omega]\_2\)], "+", 
          \(\(8\ \[Delta]\^2\ A\_1\%2\ \[Omega]\_1\ 
                A\&_\_1\)\/\(\[Omega]\_2\%2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\), "+", 
          \(\(5\ \[Delta]\^2\ A\_1\%2\ A\&_\_1\)\/\(\[Omega]\_2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\), "+", 
          FractionBox[
            RowBox[{
            "2", " ", "I", " ", \(E\^\(I\ T\_1\ \[Sigma]\)\), " ", 
              "\[Delta]", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}], " ", \(\[Omega]\_1\), " ", 
              \(A\&_\_1\)}], 
            \(\[Omega]\_2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)], "+", 
          \(\(2\ \[Delta]\^2\ A\_1\ A\_2\ A\&_\_2\)\/\(\[Omega]\_1\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)}], ",", "0", ",", 
        "0"}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ST22 = 
      Coefficient[order3Eqrhs /. expRule1[2], Exp[I\ \[Omega]\_2\ T\_0]]; \n
    ST22 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
        RowBox[{
          RowBox[{"-", 
            RowBox[{"(", 
              InterpretationBox[\(D\_2\[InvisibleSpace]A\_2\),
                SequenceForm[ 
                  Subscript[ D, 2], 
                  Subscript[ A, 2]],
                Editable->False], ")"}]}], "-", 
          FractionBox[
            RowBox[{\(E\^\(\(-I\)\ T\_1\ \[Sigma]\)\), " ", "\[Delta]", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}], " ", \(A\_1\)}], 
            \(\[Omega]\_2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)]}], ",", 
        RowBox[{
          RowBox[{\(-I\), " ", 
            RowBox[{"(", 
              InterpretationBox[\(D\_2\[InvisibleSpace]A\_2\),
                SequenceForm[ 
                  Subscript[ D, 2], 
                  Subscript[ A, 2]],
                Editable->False], ")"}], " ", \(\[Omega]\_2\)}], "+", 
          FractionBox[
            RowBox[{
            "I", " ", \(E\^\(\(-I\)\ T\_1\ \[Sigma]\)\), " ", "\[Delta]", 
              " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}], " ", \(A\_1\)}], 
            \(2\ \[Omega]\_1 + \[Omega]\_2\)], "+", 
          \(\(2\ \[Delta]\^2\ A\_1\ A\_2\ A\&_\_1\)\/\(\[Omega]\_1\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Hence, demanding that ",
  StyleBox["ST21",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["ST22",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " be orthogonal to the components of ",
  StyleBox["ccleftVec",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields the solvability conditions"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(SCond2 = {Expand[ccleftVec[\([1]\)] . ST21] == 0, 
        Expand[ccleftVec[\([2]\)] . ST22] == 0}; \nSCond2 /. displayRule\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{\(-2\), " ", "I", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_2\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 2], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}], " ", \(\[Omega]\_1\)}], "+", 
            \(\(8\ \[Delta]\^2\ A\_1\%2\ \[Omega]\_1\ 
                  A\&_\_1\)\/\(\[Omega]\_2\%2\ 
                  \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\), "+", 
            \(\(5\ \[Delta]\^2\ A\_1\%2\ A\&_\_1\)\/\(\[Omega]\_2\ 
                  \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\), "+", 
            \(\(2\ \[Delta]\^2\ A\_1\ A\_2\ A\&_\_2\)\/\(\[Omega]\_1\ 
                  \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)}], "==", "0"}], 
        ",", 
        RowBox[{
          RowBox[{
            RowBox[{\(-2\), " ", "I", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_2\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 2], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}], " ", \(\[Omega]\_2\)}], "+", 
            \(\(2\ \[Delta]\^2\ A\_1\ A\_2\ A\&_\_1\)\/\(\[Omega]\_1\ 
                  \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)}], "==", "0"}]}], 
      "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["or", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"SCond2Rule1", "=", 
        RowBox[{
          RowBox[{"Solve", "[", 
            RowBox[{"SCond2", ",", 
              RowBox[{"{", 
                RowBox[{
                  RowBox[{
                    SubsuperscriptBox["A", "1", 
                      TagBox[\((0, 1)\),
                        Derivative],
                      MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}], 
                  ",", 
                  RowBox[{
                    SubsuperscriptBox["A", "2", 
                      TagBox[\((0, 1)\),
                        Derivative],
                      MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], 
                "}"}]}], "]"}], "[", \([1]\), "]"}]}], ";", "\n", 
      \(SCond2Rule1 /. displayRule\)}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          InterpretationBox[\(D\_2\[InvisibleSpace]A\_1\),
            SequenceForm[ 
              Subscript[ D, 2], 
              Subscript[ A, 1]],
            Editable->False], "\[Rule]", 
          \(-\(\(I\ 
                  \((8\ \[Delta]\^2\ A\_1\%2\ \[Omega]\_1\%2\ A\&_\_1 + 
                      5\ \[Delta]\^2\ A\_1\%2\ \[Omega]\_1\ \[Omega]\_2\ 
                        A\&_\_1 + 
                      2\ \[Delta]\^2\ A\_1\ A\_2\ \[Omega]\_2\%2\ A\&_\_2)
                    \)\)\/\(2\ \[Omega]\_1\%2\ \[Omega]\_2\%2\ 
                  \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)\)}], ",", 
        RowBox[{
          InterpretationBox[\(D\_2\[InvisibleSpace]A\_2\),
            SequenceForm[ 
              Subscript[ D, 2], 
              Subscript[ A, 2]],
            Editable->False], "\[Rule]", 
          \(-\(\(I\ \[Delta]\^2\ A\_1\ A\_2\ A\&_\_1\)\/\(\[Omega]\_1\ 
                  \[Omega]\_2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)\)}]}], 
      "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reconstitution", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "We reconstitute ",
  StyleBox["SCond1Rule1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["SCond2Rule1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(moduEq = 
      Table[2\ I\ \[Omega]\_k\ A\_k\^\[Prime], {k, 2}] == 
          \((\(Table[
                    2\ I\ \[Omega]\_k\ \(dt[1]\)[\ A\_k[T\_1, T\_2]], {k, 
                      2}] /. SCond1Rule1\) /. SCond2Rule1 // Expand)\) // 
        Thread; \nmoduEq /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_1\), " ", 
            SubsuperscriptBox["A", "1", "\[Prime]",
              MultilineFunction->None]}], "==", 
          \(2\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[Epsilon]\ A\_2\ 
              A\&_\_1 + 
            \(8\ \[Delta]\^2\ \[Epsilon]\^2\ A\_1\%2\ \[Omega]\_1\ 
                A\&_\_1\)\/\(\[Omega]\_2\%2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
            \(5\ \[Delta]\^2\ \[Epsilon]\^2\ A\_1\%2\ 
                A\&_\_1\)\/\(\[Omega]\_2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
            \(2\ \[Delta]\^2\ \[Epsilon]\^2\ A\_1\ A\_2\ 
                A\&_\_2\)\/\(\[Omega]\_1\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)}], ",", 
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_2\), " ", 
            SubsuperscriptBox["A", "2", "\[Prime]",
              MultilineFunction->None]}], "==", 
          \(E\^\(\(-I\)\ T\_1\ \[Sigma]\)\ \[Delta]\ \[Epsilon]\ A\_1\%2 + 
            \(2\ \[Delta]\^2\ \[Epsilon]\^2\ A\_1\ A\_2\ 
                A\&_\_1\)\/\(\[Omega]\_1\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["These equations are derivable from a Lagrangian because", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Coefficient[moduEq[\([1, 2]\)], 
              A\_1[T\_1, T\_2]\ A\_2[T\_1, T\_2]\ A\&_\_2[T\_1, T\_2]] - 
            Coefficient[moduEq[\([2, 2]\)], 
              A\_1[T\_1, T\_2]\ A\_2[T\_1, T\_2]\ A\&_\_1[T\_1, T\_2]] == 
          0 /. \[Epsilon] -> 1\) /. \[Omega]\_2 -> 2  \[Omega]\_1\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(True\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
Therefore, treatment of the first-order version of the governing equations \
yields consistent results without floating constants.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["5.2.3 First-Order Complex-Valued System", "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "In this section, we show that treatment of a first-order complex -valued \
version of the governing equations yields consistent results without floating \
constants. We start by transforming the second-order form ",
  StyleBox["EOM1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " of the governing equations into a system of first-order complex-valued \
equations by introducing the transformation"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(transfRule = {u\_k_[t] -> \[Zeta]\_k[t] + \[Zeta]\&_\_k[t], 
        \(u\_k_\^\[Prime]\)[t] -> 
          I\ \[Omega]\_k\ \((\[Zeta]\_k[t] - \[Zeta]\&_\_k[t])\)}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["Then, we define the dependent variables", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(depVar = {u\_1[t], \(u\_1\^\[Prime]\)[t], u\_2[t], 
        \(u\_2\^\[Prime]\)[t]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(nmodes = {\[Zeta]\_1[t], \[Zeta]\&_\_1[t], \[Zeta]\_2[t], 
        \[Zeta]\&_\_2[t]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["transfRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["depVar ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "and solving for the ",
  StyleBox["nmodes",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(zetaRule = 
      \(Solve[depVar == \((depVar /. transfRule)\) // Thread, nmodes]\)[
        \([1]\)]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{\(\[Zeta]\_1[t]\), "\[Rule]", 
          RowBox[{"-", 
            FractionBox[
              RowBox[{\(\(-\[Omega]\_1\)\ u\_1[t]\), "+", 
                RowBox[{"I", " ", 
                  RowBox[{
                    SubsuperscriptBox["u", "1", "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}]}]}], 
              \(2\ \[Omega]\_1\)]}]}], ",", 
        RowBox[{\(\[Zeta]\&_\_1[t]\), "\[Rule]", 
          RowBox[{"-", 
            FractionBox[
              RowBox[{\(\(-\[Omega]\_1\)\ u\_1[t]\), "-", 
                RowBox[{"I", " ", 
                  RowBox[{
                    SubsuperscriptBox["u", "1", "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}]}]}], 
              \(2\ \[Omega]\_1\)]}]}], ",", 
        RowBox[{\(\[Zeta]\_2[t]\), "\[Rule]", 
          RowBox[{"-", 
            FractionBox[
              RowBox[{\(\(-\[Omega]\_2\)\ u\_2[t]\), "+", 
                RowBox[{"I", " ", 
                  RowBox[{
                    SubsuperscriptBox["u", "2", "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}]}]}], 
              \(2\ \[Omega]\_2\)]}]}], ",", 
        RowBox[{\(\[Zeta]\&_\_2[t]\), "\[Rule]", 
          RowBox[{"-", 
            FractionBox[
              RowBox[{\(\(-\[Omega]\_2\)\ u\_2[t]\), "-", 
                RowBox[{"I", " ", 
                  RowBox[{
                    SubsuperscriptBox["u", "2", "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}]}]}], 
              \(2\ \[Omega]\_2\)]}]}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "It follows from ",
  StyleBox["EOM1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " that the acceleration is given by"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(acceleration = 
      \(Solve[EOM1, {\(u\_1\^\[DoublePrime]\)[t], 
            \(u\_2\^\[DoublePrime]\)[t]}]\)[\([1]\)]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SubsuperscriptBox["u", "1", "\[DoublePrime]",
              MultilineFunction->None], "[", "t", "]"}], "\[Rule]", 
          \(\(-\[Omega]\_1\%2\)\ u\_1[t] + 2\ \[Delta]\ u\_1[t]\ u\_2[t]\)}], 
        ",", 
        RowBox[{
          RowBox[{
            SubsuperscriptBox["u", "2", "\[DoublePrime]",
              MultilineFunction->None], "[", "t", "]"}], "\[Rule]", 
          \(\[Delta]\ u\_1[t]\^2 - \[Omega]\_2\%2\ u\_2[t]\)}]}], "}"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Then, differentiating the dependent variables in ",
  StyleBox["zetaRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and using ",
  StyleBox["transfRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["acceleration",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we transform the system of two second-order equations ",
  StyleBox["EOM1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into the following two first-order complex-valued equations:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(EOM3 = 
      \(\(\[Zeta]\_#\^\[Prime]\)[t] == 
            \((\(D[\[Zeta]\_#[t] /. zetaRule, t] /. acceleration\) /. 
                  transfRule // Expand)\)\ &\)\ /@\ {1, 2}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SubsuperscriptBox["\[Zeta]", "1", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", 
          \(I\ \[Omega]\_1\ \[Zeta]\_1[t] - 
            \(I\ \[Delta]\ \[Zeta]\_1[t]\ \[Zeta]\_2[t]\)\/\[Omega]\_1 - 
            \(I\ \[Delta]\ \[Zeta]\_2[t]\ \[Zeta]\&_\_1[t]\)\/\[Omega]\_1 - 
            \(I\ \[Delta]\ \[Zeta]\_1[t]\ \[Zeta]\&_\_2[t]\)\/\[Omega]\_1 - 
            \(I\ \[Delta]\ \[Zeta]\&_\_1[t]\ \[Zeta]\&_\_2[t]\)\/\[Omega]\_1
                \)}], ",", 
        RowBox[{
          RowBox[{
            SubsuperscriptBox["\[Zeta]", "2", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", 
          \(\(-\(\(I\ \[Delta]\ \[Zeta]\_1[t]\^2\)\/\(2\ \[Omega]\_2\)\)\) + 
            I\ \[Omega]\_2\ \[Zeta]\_2[t] - 
            \(I\ \[Delta]\ \[Zeta]\_1[t]\ \[Zeta]\&_\_1[t]\)\/\[Omega]\_2 - 
            \(I\ \[Delta]\ \[Zeta]\&_\_1[t]\^2\)\/\(2\ \[Omega]\_2\)\)}]}], 
      "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "To determine a second-order uniform expansion of the solution of ",
  StyleBox["EOM3",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " using the method of multiple scales, we expand \[Zeta] and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Zeta]\&_\)]],
  " in the form"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(solRule = {
        \[Zeta]\_i_ -> 
          \((Sum[\[Epsilon]\^j\ \[Zeta]\_\(i, j\)[#1, #2, #3], {j, 3}]\ &)\), 
        \[Zeta]\&_\_i_ -> 
          \((Sum[\[Epsilon]\^j\ \[Zeta]\&_\_\(i, j\)[#1, #2, #3], {j, 3}]\ &)
            \)}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eq523a = 
      \((\(EOM3 /. multiScales\) /. solRule // ExpandAll)\) /. 
        \[Epsilon]\^\(n_ /; n > 3\) -> 0; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[
"Equating coefficients of like powers of \[Epsilon], we obtain"], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eqEps = 
      \(Rest[Thread[CoefficientList[Subtract\ @@\ #, \[Epsilon]] == 0]]\ &
            \)\ /@\ eq523a // Transpose; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
To place the linear operator on one side and the nonhomogeneous terms on the \
other side, we define\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(eqOrder[i_] := 
      \((\(#[\([1]\)]\ &\)\ /@\ eqEps[\([1]\)] /. 
              u_\_\(k_, 1\) -> u\_\(k, i\))\) == 
          \((\(#[\([1]\)]\ &\)\ /@\ eqEps[\([1]\)] /. 
                u_\_\(k_, 1\) -> u\_\(k, i\))\) - 
            \((\(#[\([1]\)]\ &\)\ /@\ eqEps[\([i]\)])\) // Thread\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using ",
  StyleBox["eqOrder[i]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and the ",
  StyleBox["displayRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we rewrite ",
  StyleBox["eqEps",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in a concise way as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[{
    \(eqOrder[1] /. displayRule // TableForm\), 
    \(eqOrder[2] /. displayRule // TableForm\), 
    \(eqOrder[3] /. displayRule // TableForm\)}], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]\[Zeta]\_\(1, 1\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ \[Zeta], 1, 1]],
                  Editable->False], "-", 
                \(I\ \[Omega]\_1\ \[Zeta]\_\(1, 1\)\)}], "==", "0"}]},
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]\[Zeta]\_\(2, 1\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ \[Zeta], 2, 1]],
                  Editable->False], "-", 
                \(I\ \[Omega]\_2\ \[Zeta]\_\(2, 1\)\)}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ \[Zeta], 1, 1]], 
            Times[ 
              Complex[ 0, -1], 
              Subscript[ \[Omega], 1], 
              Subscript[ \[Zeta], 1, 1]]], 0], 
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ \[Zeta], 2, 1]], 
            Times[ 
              Complex[ 0, -1], 
              Subscript[ \[Omega], 2], 
              Subscript[ \[Zeta], 2, 1]]], 0]}]]], "Output",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]\[Zeta]\_\(1, 2\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ \[Zeta], 1, 2]],
                  Editable->False], "-", 
                \(I\ \[Omega]\_1\ \[Zeta]\_\(1, 2\)\)}], "==", 
              RowBox[{
                RowBox[{"-", 
                  RowBox[{"(", 
                    
                    InterpretationBox[
                      \(D\_1\[InvisibleSpace]\[Zeta]\_\(1, 1\)\),
                      SequenceForm[ 
                        Subscript[ D, 1], 
                        Subscript[ \[Zeta], 1, 1]],
                      Editable->False], ")"}]}], "-", 
                \(\(I\ \[Delta]\ \[Zeta]\_\(1, 1\)\ 
                      \[Zeta]\_\(2, 1\)\)\/\[Omega]\_1\), "-", 
                \(\(I\ \[Delta]\ \[Zeta]\_\(2, 1\)\ 
                      \[Zeta]\&_\_\(1, 1\)\)\/\[Omega]\_1\), "-", 
                \(\(I\ \[Delta]\ \[Zeta]\_\(1, 1\)\ 
                      \[Zeta]\&_\_\(2, 1\)\)\/\[Omega]\_1\), "-", 
                \(\(I\ \[Delta]\ \[Zeta]\&_\_\(1, 1\)\ 
                      \[Zeta]\&_\_\(2, 1\)\)\/\[Omega]\_1\)}]}]},
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]\[Zeta]\_\(2, 2\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ \[Zeta], 2, 2]],
                  Editable->False], "-", 
                \(I\ \[Omega]\_2\ \[Zeta]\_\(2, 2\)\)}], "==", 
              RowBox[{
                RowBox[{"-", 
                  RowBox[{"(", 
                    
                    InterpretationBox[
                      \(D\_1\[InvisibleSpace]\[Zeta]\_\(2, 1\)\),
                      SequenceForm[ 
                        Subscript[ D, 1], 
                        Subscript[ \[Zeta], 2, 1]],
                      Editable->False], ")"}]}], "-", 
                \(\(I\ \[Delta]\ \[Zeta]\_\(1, 1\)\%2\)\/\(2\ 
                      \[Omega]\_2\)\), "-", 
                \(\(I\ \[Delta]\ \[Zeta]\_\(1, 1\)\ 
                      \[Zeta]\&_\_\(1, 1\)\)\/\[Omega]\_2\), "-", 
                \(\(I\ \[Delta]\ \[Zeta]\&_\_\(1, 1\)\%2\)\/\(2\ 
                      \[Omega]\_2\)\)}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ \[Zeta], 1, 2]], 
            Times[ 
              Complex[ 0, -1], 
              Subscript[ \[Omega], 1], 
              Subscript[ \[Zeta], 1, 2]]], 
          Plus[ 
            Times[ -1, 
              SequenceForm[ 
                Subscript[ D, 1], 
                Subscript[ \[Zeta], 1, 1]]], 
            Times[ 
              Complex[ 0, -1], \[Delta], 
              Power[ 
                Subscript[ \[Omega], 1], -1], 
              Subscript[ \[Zeta], 1, 1], 
              Subscript[ \[Zeta], 2, 1]], 
            Times[ 
              Complex[ 0, -1], \[Delta], 
              Power[ 
                Subscript[ \[Omega], 1], -1], 
              Subscript[ \[Zeta], 2, 1], 
              Subscript[ 
                OverBar[ \[Zeta]], 1, 1]], 
            Times[ 
              Complex[ 0, -1], \[Delta], 
              Power[ 
                Subscript[ \[Omega], 1], -1], 
              Subscript[ \[Zeta], 1, 1], 
              Subscript[ 
                OverBar[ \[Zeta]], 2, 1]], 
            Times[ 
              Complex[ 0, -1], \[Delta], 
              Power[ 
                Subscript[ \[Omega], 1], -1], 
              Subscript[ 
                OverBar[ \[Zeta]], 1, 1], 
              Subscript[ 
                OverBar[ \[Zeta]], 2, 1]]]], 
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ \[Zeta], 2, 2]], 
            Times[ 
              Complex[ 0, -1], 
              Subscript[ \[Omega], 2], 
              Subscript[ \[Zeta], 2, 2]]], 
          Plus[ 
            Times[ -1, 
              SequenceForm[ 
                Subscript[ D, 1], 
                Subscript[ \[Zeta], 2, 1]]], 
            Times[ 
              Complex[ 0, 
                Rational[ -1, 2]], \[Delta], 
              Power[ 
                Subscript[ \[Omega], 2], -1], 
              Power[ 
                Subscript[ \[Zeta], 1, 1], 2]], 
            Times[ 
              Complex[ 0, -1], \[Delta], 
              Power[ 
                Subscript[ \[Omega], 2], -1], 
              Subscript[ \[Zeta], 1, 1], 
              Subscript[ 
                OverBar[ \[Zeta]], 1, 1]], 
            Times[ 
              Complex[ 0, 
                Rational[ -1, 2]], \[Delta], 
              Power[ 
                Subscript[ \[Omega], 2], -1], 
              Power[ 
                Subscript[ 
                  OverBar[ \[Zeta]], 1, 1], 2]]]]}]]], "Output",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]\[Zeta]\_\(1, 3\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ \[Zeta], 1, 3]],
                  Editable->False], "-", 
                \(I\ \[Omega]\_1\ \[Zeta]\_\(1, 3\)\)}], "==", 
              RowBox[{
                RowBox[{"-", 
                  RowBox[{"(", 
                    
                    InterpretationBox[
                      \(D\_1\[InvisibleSpace]\[Zeta]\_\(1, 2\)\),
                      SequenceForm[ 
                        Subscript[ D, 1], 
                        Subscript[ \[Zeta], 1, 2]],
                      Editable->False], ")"}]}], "-", 
                InterpretationBox[\(D\_2\[InvisibleSpace]\[Zeta]\_\(1, 1\)\),
                  SequenceForm[ 
                    Subscript[ D, 2], 
                    Subscript[ \[Zeta], 1, 1]],
                  Editable->False], "-", 
                \(\(I\ \[Delta]\ \[Zeta]\_\(1, 2\)\ 
                      \[Zeta]\_\(2, 1\)\)\/\[Omega]\_1\), "-", 
                \(\(I\ \[Delta]\ \[Zeta]\_\(1, 1\)\ 
                      \[Zeta]\_\(2, 2\)\)\/\[Omega]\_1\), "-", 
                \(\(I\ \[Delta]\ \[Zeta]\_\(2, 2\)\ 
                      \[Zeta]\&_\_\(1, 1\)\)\/\[Omega]\_1\), "-", 
                \(\(I\ \[Delta]\ \[Zeta]\_\(2, 1\)\ 
                      \[Zeta]\&_\_\(1, 2\)\)\/\[Omega]\_1\), "-", 
                \(\(I\ \[Delta]\ \[Zeta]\_\(1, 2\)\ 
                      \[Zeta]\&_\_\(2, 1\)\)\/\[Omega]\_1\), "-", 
                \(\(I\ \[Delta]\ \[Zeta]\&_\_\(1, 2\)\ 
                      \[Zeta]\&_\_\(2, 1\)\)\/\[Omega]\_1\), "-", 
                \(\(I\ \[Delta]\ \[Zeta]\_\(1, 1\)\ 
                      \[Zeta]\&_\_\(2, 2\)\)\/\[Omega]\_1\), "-", 
                \(\(I\ \[Delta]\ \[Zeta]\&_\_\(1, 1\)\ 
                      \[Zeta]\&_\_\(2, 2\)\)\/\[Omega]\_1\)}]}]},
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]\[Zeta]\_\(2, 3\)\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ \[Zeta], 2, 3]],
                  Editable->False], "-", 
                \(I\ \[Omega]\_2\ \[Zeta]\_\(2, 3\)\)}], "==", 
              RowBox[{
                RowBox[{"-", 
                  RowBox[{"(", 
                    
                    InterpretationBox[
                      \(D\_1\[InvisibleSpace]\[Zeta]\_\(2, 2\)\),
                      SequenceForm[ 
                        Subscript[ D, 1], 
                        Subscript[ \[Zeta], 2, 2]],
                      Editable->False], ")"}]}], "-", 
                InterpretationBox[\(D\_2\[InvisibleSpace]\[Zeta]\_\(2, 1\)\),
                  SequenceForm[ 
                    Subscript[ D, 2], 
                    Subscript[ \[Zeta], 2, 1]],
                  Editable->False], "-", 
                \(\(I\ \[Delta]\ \[Zeta]\_\(1, 1\)\ 
                      \[Zeta]\_\(1, 2\)\)\/\[Omega]\_2\), "-", 
                \(\(I\ \[Delta]\ \[Zeta]\_\(1, 2\)\ 
                      \[Zeta]\&_\_\(1, 1\)\)\/\[Omega]\_2\), "-", 
                \(\(I\ \[Delta]\ \[Zeta]\_\(1, 1\)\ 
                      \[Zeta]\&_\_\(1, 2\)\)\/\[Omega]\_2\), "-", 
                \(\(I\ \[Delta]\ \[Zeta]\&_\_\(1, 1\)\ 
                      \[Zeta]\&_\_\(1, 2\)\)\/\[Omega]\_2\)}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ \[Zeta], 1, 3]], 
            Times[ 
              Complex[ 0, -1], 
              Subscript[ \[Omega], 1], 
              Subscript[ \[Zeta], 1, 3]]], 
          Plus[ 
            Times[ -1, 
              SequenceForm[ 
                Subscript[ D, 1], 
                Subscript[ \[Zeta], 1, 2]]], 
            Times[ -1, 
              SequenceForm[ 
                Subscript[ D, 2], 
                Subscript[ \[Zeta], 1, 1]]], 
            Times[ 
              Complex[ 0, -1], \[Delta], 
              Power[ 
                Subscript[ \[Omega], 1], -1], 
              Subscript[ \[Zeta], 1, 2], 
              Subscript[ \[Zeta], 2, 1]], 
            Times[ 
              Complex[ 0, -1], \[Delta], 
              Power[ 
                Subscript[ \[Omega], 1], -1], 
              Subscript[ \[Zeta], 1, 1], 
              Subscript[ \[Zeta], 2, 2]], 
            Times[ 
              Complex[ 0, -1], \[Delta], 
              Power[ 
                Subscript[ \[Omega], 1], -1], 
              Subscript[ \[Zeta], 2, 2], 
              Subscript[ 
                OverBar[ \[Zeta]], 1, 1]], 
            Times[ 
              Complex[ 0, -1], \[Delta], 
              Power[ 
                Subscript[ \[Omega], 1], -1], 
              Subscript[ \[Zeta], 2, 1], 
              Subscript[ 
                OverBar[ \[Zeta]], 1, 2]], 
            Times[ 
              Complex[ 0, -1], \[Delta], 
              Power[ 
                Subscript[ \[Omega], 1], -1], 
              Subscript[ \[Zeta], 1, 2], 
              Subscript[ 
                OverBar[ \[Zeta]], 2, 1]], 
            Times[ 
              Complex[ 0, -1], \[Delta], 
              Power[ 
                Subscript[ \[Omega], 1], -1], 
              Subscript[ 
                OverBar[ \[Zeta]], 1, 2], 
              Subscript[ 
                OverBar[ \[Zeta]], 2, 1]], 
            Times[ 
              Complex[ 0, -1], \[Delta], 
              Power[ 
                Subscript[ \[Omega], 1], -1], 
              Subscript[ \[Zeta], 1, 1], 
              Subscript[ 
                OverBar[ \[Zeta]], 2, 2]], 
            Times[ 
              Complex[ 0, -1], \[Delta], 
              Power[ 
                Subscript[ \[Omega], 1], -1], 
              Subscript[ 
                OverBar[ \[Zeta]], 1, 1], 
              Subscript[ 
                OverBar[ \[Zeta]], 2, 2]]]], 
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ \[Zeta], 2, 3]], 
            Times[ 
              Complex[ 0, -1], 
              Subscript[ \[Omega], 2], 
              Subscript[ \[Zeta], 2, 3]]], 
          Plus[ 
            Times[ -1, 
              SequenceForm[ 
                Subscript[ D, 1], 
                Subscript[ \[Zeta], 2, 2]]], 
            Times[ -1, 
              SequenceForm[ 
                Subscript[ D, 2], 
                Subscript[ \[Zeta], 2, 1]]], 
            Times[ 
              Complex[ 0, -1], \[Delta], 
              Power[ 
                Subscript[ \[Omega], 2], -1], 
              Subscript[ \[Zeta], 1, 1], 
              Subscript[ \[Zeta], 1, 2]], 
            Times[ 
              Complex[ 0, -1], \[Delta], 
              Power[ 
                Subscript[ \[Omega], 2], -1], 
              Subscript[ \[Zeta], 1, 2], 
              Subscript[ 
                OverBar[ \[Zeta]], 1, 1]], 
            Times[ 
              Complex[ 0, -1], \[Delta], 
              Power[ 
                Subscript[ \[Omega], 2], -1], 
              Subscript[ \[Zeta], 1, 1], 
              Subscript[ 
                OverBar[ \[Zeta]], 1, 2]], 
            Times[ 
              Complex[ 0, -1], \[Delta], 
              Power[ 
                Subscript[ \[Omega], 2], -1], 
              Subscript[ 
                OverBar[ \[Zeta]], 1, 1], 
              Subscript[ 
                OverBar[ \[Zeta]], 1, 2]]]]}]]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell["First-Order Equations", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Since ",
  StyleBox["eqOrder[1]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " are homogeneous, we can write their solutions as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1 = 
      Table[{\[Zeta]\_\(i, 1\) -> 
              Function[{T\_0, T\_1, T\_2}, 
                A\_i[T\_1, T\_2]\ Exp[I\ \[Omega]\_i\ T\_0] // Evaluate], 
            \[Zeta]\&_\_\(i, 1\) -> 
              Function[{T\_0, T\_1, T\_2}, 
                A\&_\_i[T\_1, T\_2]\ Exp[\(-I\)\ \[Omega]\_i\ T\_0] // 
                  Evaluate]}, {i, 2}] // Flatten\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Zeta]\_\(1, 1\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          E\^\(I\ T\_0\ \[Omega]\_1\)\ A\_1[T\_1, T\_2]], 
      \[Zeta]\&_\_\(1, 1\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          E\^\(\(-I\)\ T\_0\ \[Omega]\_1\)\ A\&_\_1[T\_1, T\_2]], 
      \[Zeta]\_\(2, 1\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          E\^\(I\ T\_0\ \[Omega]\_2\)\ A\_2[T\_1, T\_2]], 
      \[Zeta]\&_\_\(2, 1\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          E\^\(\(-I\)\ T\_0\ \[Omega]\_2\)\ A\&_\_2[T\_1, T\_2]]}\)], "Output",\

  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Second-Order Equations", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting the first-order solution into the second-order equations, ",
  StyleBox["eqOrder[2]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order2Eq = eqOrder[2] /. sol1; \norder2Eq /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]\[Zeta]\_\(1, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ \[Zeta], 1, 2]],
              Editable->False], "-", \(I\ \[Omega]\_1\ \[Zeta]\_\(1, 2\)\)}], 
          "==", 
          RowBox[{
            RowBox[{\(-E\^\(I\ T\_0\ \[Omega]\_1\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}]}], "-", 
            \(\(I\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                  \[Delta]\ A\_1\ A\_2\)\/\[Omega]\_1\), "-", 
            \(\(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                  \[Delta]\ A\_2\ A\&_\_1\)\/\[Omega]\_1\), "-", 
            \(\(I\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                  \[Delta]\ A\_1\ A\&_\_2\)\/\[Omega]\_1\), "-", 
            \(\(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                  \[Delta]\ A\&_\_1\ A\&_\_2\)\/\[Omega]\_1\)}]}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]\[Zeta]\_\(2, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ \[Zeta], 2, 2]],
              Editable->False], "-", \(I\ \[Omega]\_2\ \[Zeta]\_\(2, 2\)\)}], 
          "==", 
          RowBox[{
            RowBox[{\(-E\^\(I\ T\_0\ \[Omega]\_2\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}]}], "-", 
            \(\(I\ E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\ A\_1\%2\)\/\(2\ 
                  \[Omega]\_2\)\), "-", 
            \(\(I\ \[Delta]\ A\_1\ A\&_\_1\)\/\[Omega]\_2\), "-", 
            \(\(I\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\ 
                  A\&_\_1\%2\)\/\(2\ \[Omega]\_2\)\)}]}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Converting the terms that produce small-divisor terms by using the ",
  StyleBox["expRule1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and then eliminating the terms that lead to secular terms from ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(SCond1 = 
      \(Coefficient[order2Eq[\([#, 2]\)] /. expRule1[#], 
              Exp[I\ \[Omega]\_#\ T\_0]] == 0\ &\)\ /@\ {1, 2}; \n
    SCond1 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}]}], "-", 
            \(\(I\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ A\_2\ 
                  A\&_\_1\)\/\[Omega]\_1\)}], "==", "0"}], ",", 
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}]}], "-", 
            \(\(I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\)\ \[Delta]\ A\_1\%2\)\/\(2\ 
                  \[Omega]\_2\)\)}], "==", "0"}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["or", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"SCond1Rule1", "=", 
        RowBox[{
          RowBox[{"Solve", "[", 
            RowBox[{"SCond1", ",", 
              RowBox[{"{", 
                RowBox[{
                  RowBox[{
                    SubsuperscriptBox["A", "1", 
                      TagBox[\((1, 0)\),
                        Derivative],
                      MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}], 
                  ",", 
                  RowBox[{
                    SubsuperscriptBox["A", "2", 
                      TagBox[\((1, 0)\),
                        Derivative],
                      MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], 
                "}"}]}], "]"}], "[", \([1]\), "]"}]}], ";", "\n", 
      \(SCond1Rule1 /. displayRule\)}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          InterpretationBox[\(D\_1\[InvisibleSpace]A\_1\),
            SequenceForm[ 
              Subscript[ D, 1], 
              Subscript[ A, 1]],
            Editable->False], "\[Rule]", 
          \(-\(\(I\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ A\_2\ 
                  A\&_\_1\)\/\[Omega]\_1\)\)}], ",", 
        RowBox[{
          InterpretationBox[\(D\_1\[InvisibleSpace]A\_2\),
            SequenceForm[ 
              Subscript[ D, 1], 
              Subscript[ A, 2]],
            Editable->False], "\[Rule]", 
          \(-\(\(I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\)\ \[Delta]\ A\_1\%2\)\/\(2\ 
                  \[Omega]\_2\)\)\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Substituting ",
  StyleBox["SCond1Rule1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["expRule3",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order2Eqm = \(order2Eq /. SCond1Rule1\) /. expRule3; \n
    order2Eqm /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]\[Zeta]\_\(1, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ \[Zeta], 1, 2]],
              Editable->False], "-", \(I\ \[Omega]\_1\ \[Zeta]\_\(1, 2\)\)}], 
          "==", \(\(-
              \(\(I\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    \[Delta]\ A\_1\ A\_2\)\/\[Omega]\_1\)\) - 
            \(I\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\ A\_1\ A\&_\_2\)\/\[Omega]\_1 - 
            \(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\ A\&_\_1\ A\&_\_2\)\/\[Omega]\_1\)}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]\[Zeta]\_\(2, 2\)\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ \[Zeta], 2, 2]],
              Editable->False], "-", \(I\ \[Omega]\_2\ \[Zeta]\_\(2, 2\)\)}], 
          "==", \(\(-\(\(I\ \[Delta]\ A\_1\ A\&_\_1\)\/\[Omega]\_2\)\) - 
            \(I\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\ 
                A\&_\_1\%2\)\/\(2\ \[Omega]\_2\)\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "We transform ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into a set of ordinary-differential equations and obtain their particular \
solutions as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(sol2p = 
      \(DSolve[order2Eqm /. 
              \[Zeta]\_\(i_, 2\) -> \((\[Zeta]\_\(i, 2\)[#1]\ &)\), {
              \[Zeta]\_\(1, 2\)[T\_0], \[Zeta]\_\(2, 2\)[T\_0]}, T\_0]\)[
          \([1]\)] /. C[_] -> 0; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(expRule4 = Exp[a_] :> Exp[Expand[a]]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["We write the second-order solution in function form as", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2 = 
      Table[{\[Zeta]\_\(i, 2\) -> 
              Function[{T\_0, T\_1, T\_2}, 
                \((sol2p[\([i, 2]\)] // Expand)\) /. expRule4 // Evaluate], 
            \[Zeta]\&_\_\(i, 2\) -> 
              Function[{T\_0, T\_1, T\_2}, 
                \(\((sol2p[\([i, 2]\)] // Expand)\) /. expRule4\) /. 
                    conjugateRule // Evaluate]}, {i, 2}] // Flatten; \n
    sol2 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Zeta]\_\(1, 2\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          \(-\(\(E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                    \[Delta]\ A\_1\ A\_2\)\/\(\[Omega]\_1\ 
                    \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)\) - 
            \(2\ E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\ A\_1\ A\_2\)\/\(\[Omega]\_2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
            \(E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ \[Delta]\ 
                A\_1\ A\&_\_2\)\/\(\[Omega]\_1\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
            \(2\ E\^\(I\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\ A\_1\ A\&_\_2\)\/\(\[Omega]\_2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
            \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\ A\&_\_1\ A\&_\_2\)\/\(\[Omega]\_1\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)], 
      \[Zeta]\&_\_\(1, 2\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          \(E\^\(I\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ \[Delta]\ 
                A\_1\ A\_2\)\/\(\[Omega]\_1\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
            \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\ A\_2\ A\&_\_1\)\/\(\[Omega]\_1\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
            \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\ A\_2\ A\&_\_1\)\/\(\[Omega]\_2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) - 
            \(E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\ A\&_\_1\ A\&_\_2\)\/\(\[Omega]\_1\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) - 
            \(2\ E\^\(\(-I\)\ T\_0\ \[Omega]\_1 - I\ T\_0\ \[Omega]\_2\)\ 
                \[Delta]\ A\&_\_1\ A\&_\_2\)\/\(\[Omega]\_2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)], 
      \[Zeta]\_\(2, 2\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          \(2\ \[Delta]\ \[Omega]\_1\ A\_1\ A\&_\_1\)\/\(\[Omega]\_2\%2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
            \(\[Delta]\ A\_1\ A\&_\_1\)\/\(\[Omega]\_2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
            \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\ A\&_\_1\%2\)\/\(2
                \ \[Omega]\_2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)], 
      \[Zeta]\&_\_\(2, 2\) \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          \(E\^\(2\ I\ T\_0\ \[Omega]\_1\)\ \[Delta]\ A\_1\%2\)\/\(2\ 
                \[Omega]\_2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
            \(2\ \[Delta]\ \[Omega]\_1\ A\_1\ A\&_\_1\)\/\(\[Omega]\_2\%2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
            \(\[Delta]\ A\_1\ A\&_\_1\)\/\(\[Omega]\_2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Third-Order Equations", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting the first- and second-order solutions into the right-hand \
sides of the third-order equations, ",
  StyleBox["eqOrder[3]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(order3Eqrhs = 
      \(Expand[\(#[\([2]\)] /. sol1\) /. sol2]\ &\)\ /@\ eqOrder[3]; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Converting the terms that produce small-divisor terms and eliminating the \
terms that produce secular terms in ",
  Cell[BoxData[
      \(TraditionalForm\`\[Zeta]\_\(\ i, 3\)\)]],
  " from ",
  StyleBox["order3Eqrhs",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " demands the following conditions:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(SCond2 = 
      \(Coefficient[order3Eqrhs[\([#]\)] /. expRule1[#], 
              Exp[I\ \[Omega]\_#\ T\_0]] == 0\ &\)\ /@\ {1, 2}; \n
    SCond2 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              RowBox[{"(", 
                InterpretationBox[\(D\_2\[InvisibleSpace]A\_1\),
                  SequenceForm[ 
                    Subscript[ D, 2], 
                    Subscript[ A, 1]],
                  Editable->False], ")"}]}], "-", 
            \(\(4\ I\ \[Delta]\^2\ A\_1\%2\ A\&_\_1\)\/\(\[Omega]\_2\%2\ 
                  \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\), "-", 
            \(\(5\ I\ \[Delta]\^2\ A\_1\%2\ A\&_\_1\)\/\(2\ \[Omega]\_1\ 
                  \[Omega]\_2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\), "-", 
            \(\(I\ \[Delta]\^2\ A\_1\ A\_2\ A\&_\_2\)\/\(\[Omega]\_1\%2\ 
                  \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)}], "==", "0"}], 
        ",", 
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              RowBox[{"(", 
                InterpretationBox[\(D\_2\[InvisibleSpace]A\_2\),
                  SequenceForm[ 
                    Subscript[ D, 2], 
                    Subscript[ A, 2]],
                  Editable->False], ")"}]}], "-", 
            \(\(I\ \[Delta]\^2\ A\_1\ A\_2\ A\&_\_1\)\/\(\[Omega]\_1\ 
                  \[Omega]\_2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)}], 
          "==", "0"}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["or", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"SCond2Rule1", "=", 
        RowBox[{
          RowBox[{"Solve", "[", 
            RowBox[{"SCond2", ",", 
              RowBox[{"{", 
                RowBox[{
                  RowBox[{
                    SubsuperscriptBox["A", "1", 
                      TagBox[\((0, 1)\),
                        Derivative],
                      MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}], 
                  ",", 
                  RowBox[{
                    SubsuperscriptBox["A", "2", 
                      TagBox[\((0, 1)\),
                        Derivative],
                      MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], 
                "}"}]}], "]"}], "[", \([1]\), "]"}]}], ";", "\n", 
      \(SCond2Rule1 /. displayRule\)}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          InterpretationBox[\(D\_2\[InvisibleSpace]A\_1\),
            SequenceForm[ 
              Subscript[ D, 2], 
              Subscript[ A, 1]],
            Editable->False], "\[Rule]", 
          \(-\(\(I\ 
                  \((8\ \[Delta]\^2\ A\_1\%2\ \[Omega]\_1\%2\ A\&_\_1 + 
                      5\ \[Delta]\^2\ A\_1\%2\ \[Omega]\_1\ \[Omega]\_2\ 
                        A\&_\_1 + 
                      2\ \[Delta]\^2\ A\_1\ A\_2\ \[Omega]\_2\%2\ A\&_\_2)
                    \)\)\/\(2\ \[Omega]\_1\%2\ \[Omega]\_2\%2\ 
                  \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)\)}], ",", 
        RowBox[{
          InterpretationBox[\(D\_2\[InvisibleSpace]A\_2\),
            SequenceForm[ 
              Subscript[ D, 2], 
              Subscript[ A, 2]],
            Editable->False], "\[Rule]", 
          \(-\(\(I\ \[Delta]\^2\ A\_1\ A\_2\ A\&_\_1\)\/\(\[Omega]\_1\ 
                  \[Omega]\_2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)\)}]}], 
      "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reconstitution", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "We reconstitute ",
  StyleBox["SCond1Rule1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["SCond2Rule1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(moduEq = 
      Table[2\ I\ \[Omega]\_k\ A\_k\^\[Prime], {k, 2}] == 
          \((\(Table[
                    2\ I\ \[Omega]\_k\ \(dt[1]\)[\ A\_k[T\_1, T\_2]], {k, 
                      2}] /. SCond1Rule1\) /. SCond2Rule1 // Expand)\) // 
        Thread; \nmoduEq /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_1\), " ", 
            SubsuperscriptBox["A", "1", "\[Prime]",
              MultilineFunction->None]}], "==", 
          \(2\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[Epsilon]\ A\_2\ 
              A\&_\_1 + 
            \(8\ \[Delta]\^2\ \[Epsilon]\^2\ A\_1\%2\ \[Omega]\_1\ 
                A\&_\_1\)\/\(\[Omega]\_2\%2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
            \(5\ \[Delta]\^2\ \[Epsilon]\^2\ A\_1\%2\ 
                A\&_\_1\)\/\(\[Omega]\_2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
            \(2\ \[Delta]\^2\ \[Epsilon]\^2\ A\_1\ A\_2\ 
                A\&_\_2\)\/\(\[Omega]\_1\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)}], ",", 
        RowBox[{
          RowBox[{"2", " ", "I", " ", \(\[Omega]\_2\), " ", 
            SubsuperscriptBox["A", "2", "\[Prime]",
              MultilineFunction->None]}], "==", 
          \(E\^\(\(-I\)\ T\_1\ \[Sigma]\)\ \[Delta]\ \[Epsilon]\ A\_1\%2 + 
            \(2\ \[Delta]\^2\ \[Epsilon]\^2\ A\_1\ A\_2\ 
                A\&_\_1\)\/\(\[Omega]\_1\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["5.3 Method of Normal Forms", "Section",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "To apply the method of normal forms, we find it convenient to start with \
the first-order complex-valued form ",
  StyleBox["EOM3",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]]
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{"EOM3", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SubsuperscriptBox["\[Zeta]", "1", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}], "==", 
              \(I\ \[Omega]\_1\ \[Zeta]\_1[t] - 
                \(I\ \[Delta]\ \[Zeta]\_1[t]\ \[Zeta]\_2[t]\)\/\[Omega]\_1 - 
                \(I\ \[Delta]\ \[Zeta]\_2[t]\ 
                    \[Zeta]\&_\_1[t]\)\/\[Omega]\_1 - 
                \(I\ \[Delta]\ \[Zeta]\_1[t]\ 
                    \[Zeta]\&_\_2[t]\)\/\[Omega]\_1 - 
                \(I\ \[Delta]\ \[Zeta]\&_\_1[t]\ 
                    \[Zeta]\&_\_2[t]\)\/\[Omega]\_1\)}], ",", 
            RowBox[{
              RowBox[{
                SubsuperscriptBox["\[Zeta]", "2", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}], "==", 
              \(\(-\(\(I\ \[Delta]\ \[Zeta]\_1[t]\^2\)\/\(2\ 
                        \[Omega]\_2\)\)\) + I\ \[Omega]\_2\ \[Zeta]\_2[t] - 
                \(I\ \[Delta]\ \[Zeta]\_1[t]\ 
                    \[Zeta]\&_\_1[t]\)\/\[Omega]\_2 - 
                \(I\ \[Delta]\ \[Zeta]\&_\_1[t]\^2\)\/\(2\ 
                    \[Omega]\_2\)\)}]}], "}"}]}], ";"}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
of the governing equations. Then, according to the method of normal forms, we \
introduce the near-identity transformation\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(basicTerms = 
      Table[{\[Eta]\_k[t], \[Eta]\&_\_k[t]}, {k, 2}] // Flatten\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Eta]\_1[t], \[Eta]\&_\_1[t], \[Eta]\_2[t], \[Eta]\&_\_2[t]}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(zetaRule = {
        \[Zeta]\_i_ -> 
          Function[t, 
            \[Epsilon]\ \[Eta]\_i[t] + 
                Sum[\[Epsilon]\^\(j + 1\)\ 
                    h\_\(i, j\)[Sequence\ @@\ basicTerms], {j, 2}] // 
              Evaluate], 
        \[Zeta]\&_\_i_ -> 
          Function[t, 
            \[Epsilon]\ \[Eta]\&_\_i[t] + 
                Sum[\[Epsilon]\^\(j + 1\)\ 
                    h\&_\_\(i, j\)[Sequence\ @@\ basicTerms], {j, 2}] // 
              Evaluate]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Zeta]\_i_ \[Rule] 
        Function[t, 
          \[Epsilon]\ \[Eta]\_i[t] + 
            \[Epsilon]\^2\ 
              h\_\(i, 1\)[\[Eta]\_1[t], \[Eta]\&_\_1[t], \[Eta]\_2[t], 
                \[Eta]\&_\_2[t]] + 
            \[Epsilon]\^3\ 
              h\_\(i, 2\)[\[Eta]\_1[t], \[Eta]\&_\_1[t], \[Eta]\_2[t], 
                \[Eta]\&_\_2[t]]], 
      \[Zeta]\&_\_i_ \[Rule] 
        Function[t, 
          \[Epsilon]\ \[Eta]\&_\_i[t] + 
            \[Epsilon]\^2\ 
              h\&_\_\(i, 1\)[\[Eta]\_1[t], \[Eta]\&_\_1[t], \[Eta]\_2[t], 
                \[Eta]\&_\_2[t]] + 
            \[Epsilon]\^3\ 
              h\&_\_\(i, 2\)[\[Eta]\_1[t], \[Eta]\&_\_1[t], \[Eta]\_2[t], 
                \[Eta]\&_\_2[t]]]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["that results in the simplest possible equations", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(etaRule = 
      \(\[Eta]\_i_\^\[Prime]\)[t] -> 
        I\ \[Omega]\_i\ \[Eta]\_i[t] + 
          Sum[\[Epsilon]\^j\ g\_\(i, j\)[t], {j, 2}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{
        SubsuperscriptBox["\[Eta]", "i_", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "\[Rule]", 
      \(I\ \[Omega]\_i\ \[Eta]\_i[t] + \[Epsilon]\ g\_\(i, 1\)[t] + 
        \[Epsilon]\^2\ g\_\(i, 2\)[t]\)}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["where the overbar denotes the complex conjugate", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(conjugateRule = {\[Eta] -> \[Eta]\&_, \[Eta]\&_ -> \[Eta], g -> g\&_, 
        g\&_ -> g, Complex[0, n_] -> Complex[0, \(-n\)]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting the expansion for the ",
  Cell[BoxData[
      \(TraditionalForm\`\[Zeta]\_\(\ i\)\)]],
  ", the ",
  StyleBox["zetaRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", into ",
  StyleBox["EOM3",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", using the ",
  StyleBox["etaRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", expanding the result for small \[Epsilon], and discarding terms of order \
higher than ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[Epsilon]\^3, \)\)]],
  " we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eq53a = 
      \((\(\(EOM3 /. zetaRule\) /. etaRule\) /. 
              \((etaRule /. conjugateRule)\) // ExpandAll)\) /. 
        \[Epsilon]\^\(n_ /; n > 3\) -> 0; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell["Second-Order Equations", "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Collecting the coefficients of ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon]\^2\)]],
  " in ",
  StyleBox["eq53a",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(order2expr = 
      \(Coefficient[Subtract\ @@\ #, \[Epsilon]\^2]\ &\)\ /@\ eq53a; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "To determine the resonance terms in ",
  StyleBox["order2expr",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we note that all of the possible forms of its nonhomogeneous terms are"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(possibleQTerms = 
      \(Outer[Times, basicTerms, basicTerms] // Flatten\) // Union\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Eta]\_1[t]\^2, \[Eta]\_1[t]\ \[Eta]\_2[t], \[Eta]\_2[t]\^2, 
      \[Eta]\_1[t]\ \[Eta]\&_\_1[t], \[Eta]\_2[t]\ \[Eta]\&_\_1[t], 
      \[Eta]\&_\_1[t]\^2, \[Eta]\_1[t]\ \[Eta]\&_\_2[t], 
      \[Eta]\_2[t]\ \[Eta]\&_\_2[t], \[Eta]\&_\_1[t]\ \[Eta]\&_\_2[t], 
      \[Eta]\&_\_2[t]\^2}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "It follows from the linear parts of the ",
  StyleBox["etaRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " that to the first approximation"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(form = {\[Eta]\_i_[t] -> E\^\(I\ \[Omega]\_i\ t\), 
        \[Eta]\&_\_i_[t] -> E\^\(\(-I\)\ \[Omega]\_i\ t\)}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["Hence, the possible resonance terms are given by", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(ResonantQTerm[1] = 
      \(\((\(\(\(E\^\(\(-I\)\ \[Omega]\_1\ t\)\) possibleQTerms /. form\) /. 
                  \[Omega]\_2 -> 2\ \[Omega]\_1\) /. E\^\(_\ t\) -> 0)\)\ 
            possibleQTerms // Union\) // Rest\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Eta]\_2[t]\ \[Eta]\&_\_1[t]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ResonantQTerm[2] = 
      \(\((\(\(\(E\^\(\(-I\)\ \[Omega]\_2\ t\)\) possibleQTerms /. form\) /. 
                  \[Omega]\_1 -> 1\/2\ \[Omega]\_2\) /. E\^\(_\ t\) -> 0)\)\ 
            possibleQTerms // Union\) // Rest\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Eta]\_1[t]\^2}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
Then, the nonresonance terms and their associated coefficients can be defined \
as\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(Do[NRQT[i] = Complement[possibleQTerms, ResonantQTerm[i]]; 
      coeffsQ[i] = Table[\[CapitalGamma]\_\(i, j\), {j, Length[NRQT[i]]}], {
        i, 2}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Thus, the ",
  Cell[BoxData[
      \(TraditionalForm\`h\_\(i, 1\)\)]],
  " and their complex conjugates have the form"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(hFormQ = 
      Table[{h\_\(i, 1\) -> 
              \((Evaluate[
                    coeffsQ[i] . NRQT[i] /. 
                      Thread[basicTerms -> {#1, #2, #3, #4}]]\ &)\), 
            h\&_\_\(i, 1\) -> 
              \((Evaluate[
                    \(coeffsQ[i] . NRQT[i] /. conjugateRule\) /. 
                      Thread[basicTerms -> {#1, #2, #3, #4}]]\ &)\)}, {i, 
            2}] // Flatten; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting for the ",
  Cell[BoxData[
      \(TraditionalForm\`h\_\(i, 1\)\)]],
  " in ",
  StyleBox["order2expr",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", equating the coefficients of the possible nonresonance terms to zero, \
and solving the resulting algebraic equations for the ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalGamma]\_\(i, \ j\)\)]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(coeffsQRule = 
      Table[\(Solve[
              Coefficient[order2expr[\([i]\)] /. hFormQ, NRQT[i]] == 0 // 
                Thread, coeffsQ[i]]\)[\([1]\)], {i, 2}] // Flatten\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[CapitalGamma]\_\(1, 1\) \[Rule] 0, 
      \[CapitalGamma]\_\(1, 2\) \[Rule] 
        \(-\(\[Delta]\/\(\[Omega]\_1\ \[Omega]\_2\)\)\), 
      \[CapitalGamma]\_\(1, 4\) \[Rule] 0, 
      \[CapitalGamma]\_\(1, 5\) \[Rule] 0, 
      \[CapitalGamma]\_\(1, 6\) \[Rule] 
        \[Delta]\/\(\[Omega]\_1\ \[Omega]\_2\), 
      \[CapitalGamma]\_\(1, 7\) \[Rule] 0, 
      \[CapitalGamma]\_\(1, 3\) \[Rule] 0, 
      \[CapitalGamma]\_\(1, 8\) \[Rule] 
        \[Delta]\/\(\[Omega]\_1\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\), 
      \[CapitalGamma]\_\(1, 9\) \[Rule] 0, 
      \[CapitalGamma]\_\(2, 1\) \[Rule] 0, 
      \[CapitalGamma]\_\(2, 2\) \[Rule] 0, 
      \[CapitalGamma]\_\(2, 3\) \[Rule] \[Delta]\/\[Omega]\_2\%2, 
      \[CapitalGamma]\_\(2, 4\) \[Rule] 0, 
      \[CapitalGamma]\_\(2, 7\) \[Rule] 0, 
      \[CapitalGamma]\_\(2, 9\) \[Rule] 0, 
      \[CapitalGamma]\_\(2, 5\) \[Rule] 
        \[Delta]\/\(2\ \[Omega]\_2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\), 
      \[CapitalGamma]\_\(2, 6\) \[Rule] 0, 
      \[CapitalGamma]\_\(2, 8\) \[Rule] 0}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Using these coefficients, we rewrite ",
  StyleBox["hFormQ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(hSolQ = 
      Table[h\_\(i, 1\)[Sequence\ @@\ basicTerms] -> 
          \((\(h\_\(i, 1\)[Sequence\ @@\ basicTerms] /. hFormQ\) /. 
              coeffsQRule)\), {i, 2}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({h\_\(1, 1\)[\[Eta]\_1[t], \[Eta]\&_\_1[t], \[Eta]\_2[t], 
          \[Eta]\&_\_2[t]] \[Rule] 
        \(-\(\(\[Delta]\ \[Eta]\_1[t]\ \[Eta]\_2[t]\)\/\(\[Omega]\_1\ 
                  \[Omega]\_2\)\)\) + 
          \(\[Delta]\ \[Eta]\_1[t]\ \[Eta]\&_\_2[t]\)\/\(\[Omega]\_1\ 
              \[Omega]\_2\) + 
          \(\[Delta]\ \[Eta]\&_\_1[t]\ \[Eta]\&_\_2[t]\)\/\(\[Omega]\_1\ 
              \((2\ \[Omega]\_1 + \[Omega]\_2)\)\), 
      h\_\(2, 1\)[\[Eta]\_1[t], \[Eta]\&_\_1[t], \[Eta]\_2[t], 
          \[Eta]\&_\_2[t]] \[Rule] 
        \(\[Delta]\ \[Eta]\_1[t]\ \[Eta]\&_\_1[t]\)\/\[Omega]\_2\%2 + 
          \(\[Delta]\ \[Eta]\&_\_1[t]\^2\)\/\(2\ \[Omega]\_2\ 
              \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["or in pure function form as", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(hRuleQ = 
      Table[{h\_\(i, 1\) -> 
              \((Evaluate[
                    hSolQ[\([i, 2]\)] /. 
                      Thread[basicTerms -> {#1, #2, #3, #4}]]\ &)\), 
            h\&_\_\(i, 1\) -> 
              \((Evaluate[
                    \(hSolQ[\([i, 2]\)] /. conjugateRule\) /. 
                      Thread[basicTerms -> {#1, #2, #3, #4}]]\ &)\)}, {i, 
            2}] // Flatten; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "We choose the ",
  Cell[BoxData[
      \(TraditionalForm\`g\_\(i, 1\)\)]],
  " to eliminate the resonance terms in ",
  StyleBox["order2expr",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " according to"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(gRuleQ = 
      Table[g\_\(i, 1\)[t] -> 
          \(-\ Coefficient[order2expr[\([i]\)], ResonantQTerm[i]] . 
              ResonantQTerm[i]\), {i, 2}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({g\_\(1, 1\)[t] \[Rule] 
        \(-\(\(I\ \[Delta]\ \[Eta]\_2[t]\ \[Eta]\&_\_1[t]\)\/\[Omega]\_1\)\), 
      g\_\(2, 1\)[t] \[Rule] 
        \(-\(\(I\ \[Delta]\ \[Eta]\_1[t]\^2\)\/\(2\ \[Omega]\_2\)\)\)}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Third-Order Equations", "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Collecting the coefficients of ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon]\^3\)]],
  " in ",
  StyleBox["eq53a",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and using ",
  StyleBox["hRuleQ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["gRuleQ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(order3expr = 
      \(\(Map[Coefficient[Subtract\ @@\ #, \[Epsilon]\^3]\ &, eq53a] /. hRuleQ
              \) /. gRuleQ\) /. \((gRuleQ /. conjugateRule)\) // Expand; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "The nonhomogeneous terms in ",
  StyleBox["order3expr",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " are proportional to"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(possibleCTerms = 
      \(Outer[Times, possibleQTerms, basicTerms] // Flatten\) // Union\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Eta]\_1[t]\^3, \[Eta]\_1[t]\^2\ \[Eta]\_2[t], 
      \[Eta]\_1[t]\ \[Eta]\_2[t]\^2, \[Eta]\_2[t]\^3, 
      \[Eta]\_1[t]\^2\ \[Eta]\&_\_1[t], 
      \[Eta]\_1[t]\ \[Eta]\_2[t]\ \[Eta]\&_\_1[t], 
      \[Eta]\_2[t]\^2\ \[Eta]\&_\_1[t], \[Eta]\_1[t]\ \[Eta]\&_\_1[t]\^2, 
      \[Eta]\_2[t]\ \[Eta]\&_\_1[t]\^2, \[Eta]\&_\_1[t]\^3, 
      \[Eta]\_1[t]\^2\ \[Eta]\&_\_2[t], 
      \[Eta]\_1[t]\ \[Eta]\_2[t]\ \[Eta]\&_\_2[t], 
      \[Eta]\_2[t]\^2\ \[Eta]\&_\_2[t], 
      \[Eta]\_1[t]\ \[Eta]\&_\_1[t]\ \[Eta]\&_\_2[t], 
      \[Eta]\_2[t]\ \[Eta]\&_\_1[t]\ \[Eta]\&_\_2[t], 
      \[Eta]\&_\_1[t]\^2\ \[Eta]\&_\_2[t], \[Eta]\_1[t]\ \[Eta]\&_\_2[t]\^2, 
      \[Eta]\_2[t]\ \[Eta]\&_\_2[t]\^2, \[Eta]\&_\_1[t]\ \[Eta]\&_\_2[t]\^2, 
      \[Eta]\&_\_2[t]\^3}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["Next, we determine the resonance terms according to", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(ResonantCTerm[1] = 
      \(\((\(\(\(E\^\(\(-I\)\ \[Omega]\_1\ t\)\) possibleCTerms /. form\) /. 
                  \[Omega]\_2 -> 2\ \[Omega]\_1\) /. E\^\(_\ t\) -> 0)\)\ 
            possibleCTerms // Union\) // Rest\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Eta]\_1[t]\^2\ \[Eta]\&_\_1[t], 
      \[Eta]\_1[t]\ \[Eta]\_2[t]\ \[Eta]\&_\_2[t]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ResonantCTerm[2] = 
      \(\((\(\(\(E\^\(\(-I\)\ \[Omega]\_2\ t\)\) possibleCTerms /. form\) /. 
                  \[Omega]\_1 -> 1\/2\ \[Omega]\_2\) /. E\^\(_\ t\) -> 0)\)\ 
            possibleCTerms // Union\) // Rest\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Eta]\_1[t]\ \[Eta]\_2[t]\ \[Eta]\&_\_1[t], 
      \[Eta]\_2[t]\^2\ \[Eta]\&_\_2[t]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
Then, the nonresonance terms and their associated coefficients are given by\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(Do[NRCT[i] = Complement[possibleCTerms, ResonantCTerm[i]]; 
      coeffsC[i] = Table[\[CapitalLambda]\_\(i, j\), {j, Length[NRCT[i]]}], {
        i, 2}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Consequently, the ",
  Cell[BoxData[
      \(TraditionalForm\`h\_\(i, 2\)\)]],
  " and their complex conjugates have the forms"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(hFormC = 
      Table[{h\_\(i, 2\) -> 
              \((Evaluate[
                    coeffsC[i] . NRCT[i] /. 
                      Thread[basicTerms -> {#1, #2, #3, #4}]]\ &)\), 
            h\&_\_\(i, 2\) -> 
              \((Evaluate[
                    \(coeffsC[i] . NRCT[i] /. conjugateRule\) /. 
                      Thread[basicTerms -> {#1, #2, #3, #4}]]\ &)\)}, {i, 
            2}] // Flatten; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting for the ",
  Cell[BoxData[
      \(TraditionalForm\`h\_\(i, 2\)\)]],
  " in ",
  StyleBox["order3expr",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", equating the coefficient of each possible nonresonance term to zero, and \
solving the resulting algebraic equations for the ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalLambda]\_\(i, \ j\)\)]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(coeffsCRule = 
      Table[\(Solve[
              Coefficient[order3expr[\([i]\)] /. hFormC, NRCT[i]] == 0 // 
                Thread, coeffsC[i]]\)[\([1]\)], {i, 2}] // Flatten\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[CapitalLambda]\_\(1, 1\) \[Rule] 
        \(-\(\(\[Delta]\^2\ \[Omega]\_1 + \[Delta]\^2\ \[Omega]\_2\)\/\(2\ 
                \[Omega]\_1\%2\ \[Omega]\_2\%2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)\), 
      \[CapitalLambda]\_\(1, 3\) \[Rule] 
        \[Delta]\^2\/\(\[Omega]\_1\ \[Omega]\_2\%2\ 
            \((2\ \[Omega]\_1 + \[Omega]\_2)\)\), 
      \[CapitalLambda]\_\(1, 7\) \[Rule] 
        \(-\(\(\(-5\)\ \[Delta]\^2\ \[Omega]\_1 - 
                3\ \[Delta]\^2\ \[Omega]\_2\)\/\(2\ \[Omega]\_1\%2\ 
                \[Omega]\_2\%2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)\), 
      \[CapitalLambda]\_\(1, 9\) \[Rule] 
        \[Delta]\^2\/\(4\ \[Omega]\_1\%2\ \[Omega]\_2\ 
            \((2\ \[Omega]\_1 + \[Omega]\_2)\)\), 
      \[CapitalLambda]\_\(1, 13\) \[Rule] 
        \(-\(\[Delta]\^2\/\(\[Omega]\_1\%2\ \[Omega]\_2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)\), 
      \[CapitalLambda]\_\(1, 15\) \[Rule] 
        \(-\(\(\(-\[Delta]\^2\)\ \[Omega]\_1 - 
                \[Delta]\^2\ \[Omega]\_2\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\%2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)\), 
      \[CapitalLambda]\_\(1, 2\) \[Rule] 0, 
      \[CapitalLambda]\_\(1, 16\) \[Rule] 0, 
      \[CapitalLambda]\_\(1, 4\) \[Rule] 0, 
      \[CapitalLambda]\_\(1, 17\) \[Rule] 
        \(-\(\[Delta]\^2\/\(\[Omega]\_1\ \[Omega]\_2\ 
                \((\[Omega]\_1 + \[Omega]\_2)\)\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)\), 
      \[CapitalLambda]\_\(1, 5\) \[Rule] 0, 
      \[CapitalLambda]\_\(1, 18\) \[Rule] 0, 
      \[CapitalLambda]\_\(1, 10\) \[Rule] 0, 
      \[CapitalLambda]\_\(1, 8\) \[Rule] 0, 
      \[CapitalLambda]\_\(1, 6\) \[Rule] 
        \[Delta]\^2\/\(\[Omega]\_1\%2\ \((\[Omega]\_1 - \[Omega]\_2)\)\ 
            \[Omega]\_2\), \[CapitalLambda]\_\(1, 11\) \[Rule] 0, 
      \[CapitalLambda]\_\(1, 14\) \[Rule] 0, 
      \[CapitalLambda]\_\(1, 12\) \[Rule] 0, 
      \[CapitalLambda]\_\(2, 2\) \[Rule] 
        \[Delta]\^2\/\(\[Omega]\_1\ \[Omega]\_2\%2\ 
            \((2\ \[Omega]\_1 + \[Omega]\_2)\)\), 
      \[CapitalLambda]\_\(2, 4\) \[Rule] 0, 
      \[CapitalLambda]\_\(2, 8\) \[Rule] 0, 
      \[CapitalLambda]\_\(2, 12\) \[Rule] 
        \[Delta]\^2\/\(\[Omega]\_1\ \[Omega]\_2\%2\ 
            \((2\ \[Omega]\_1 + \[Omega]\_2)\)\), 
      \[CapitalLambda]\_\(2, 16\) \[Rule] 0, 
      \[CapitalLambda]\_\(2, 18\) \[Rule] 0, 
      \[CapitalLambda]\_\(2, 1\) \[Rule] 0, 
      \[CapitalLambda]\_\(2, 3\) \[Rule] 0, 
      \[CapitalLambda]\_\(2, 5\) \[Rule] 0, 
      \[CapitalLambda]\_\(2, 6\) \[Rule] 0, 
      \[CapitalLambda]\_\(2, 7\) \[Rule] 0, 
      \[CapitalLambda]\_\(2, 9\) \[Rule] 0, 
      \[CapitalLambda]\_\(2, 10\) \[Rule] 
        \(-\(\[Delta]\^2\/\(\[Omega]\_1\ \((\[Omega]\_1 - \[Omega]\_2)\)\ 
                \[Omega]\_2\%2\)\)\), \[CapitalLambda]\_\(2, 11\) \[Rule] 0, 
      \[CapitalLambda]\_\(2, 17\) \[Rule] 0, 
      \[CapitalLambda]\_\(2, 13\) \[Rule] 0, 
      \[CapitalLambda]\_\(2, 14\) \[Rule] 
        \(-\(\[Delta]\^2\/\(\[Omega]\_2\%2\ \((\[Omega]\_1 + \[Omega]\_2)\)\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)\), 
      \[CapitalLambda]\_\(2, 15\) \[Rule] 0}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Using these coefficients, we rewrite ",
  StyleBox["hFormC",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(hSolC = 
      Table[h\_\(i, 2\)[Sequence\ @@\ basicTerms] -> 
          \((\(h\_\(i, 2\)[Sequence\ @@\ basicTerms] /. hFormC\) /. 
              coeffsCRule)\), {i, 2}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({h\_\(1, 2\)[\[Eta]\_1[t], \[Eta]\&_\_1[t], \[Eta]\_2[t], 
          \[Eta]\&_\_2[t]] \[Rule] 
        \(-\(\(\((\[Delta]\^2\ \[Omega]\_1 + \[Delta]\^2\ \[Omega]\_2)\)\ 
                  \[Eta]\_1[t]\^3\)\/\(2\ \[Omega]\_1\%2\ \[Omega]\_2\%2\ 
                  \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)\) + 
          \(\[Delta]\^2\ \[Eta]\_1[t]\ \[Eta]\_2[t]\^2\)\/\(\[Omega]\_1\ 
              \[Omega]\_2\%2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
          \(\[Delta]\^2\ \[Eta]\_2[t]\^2\ 
              \[Eta]\&_\_1[t]\)\/\(\[Omega]\_1\%2\ 
              \((\[Omega]\_1 - \[Omega]\_2)\)\ \[Omega]\_2\) - 
          \(\((\(-5\)\ \[Delta]\^2\ \[Omega]\_1 - 3\ \[Delta]\^2\ \[Omega]\_2)
                \)\ \[Eta]\_1[t]\ \[Eta]\&_\_1[t]\^2\)\/\(2\ \[Omega]\_1\%2\ 
              \[Omega]\_2\%2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
          \(\[Delta]\^2\ \[Eta]\&_\_1[t]\^3\)\/\(4\ \[Omega]\_1\%2\ 
              \[Omega]\_2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) - 
          \(\[Delta]\^2\ \[Eta]\_2[t]\ \[Eta]\&_\_1[t]\ 
              \[Eta]\&_\_2[t]\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\ 
              \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) - 
          \(\((\(-\[Delta]\^2\)\ \[Omega]\_1 - \[Delta]\^2\ \[Omega]\_2)\)\ 
              \[Eta]\_1[t]\ \[Eta]\&_\_2[t]\^2\)\/\(\[Omega]\_1\%2\ 
              \[Omega]\_2\%2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) - 
          \(\[Delta]\^2\ \[Eta]\&_\_1[t]\ 
              \[Eta]\&_\_2[t]\^2\)\/\(\[Omega]\_1\ \[Omega]\_2\ 
              \((\[Omega]\_1 + \[Omega]\_2)\)\ 
              \((2\ \[Omega]\_1 + \[Omega]\_2)\)\), 
      h\_\(2, 2\)[\[Eta]\_1[t], \[Eta]\&_\_1[t], \[Eta]\_2[t], 
          \[Eta]\&_\_2[t]] \[Rule] 
        \(\[Delta]\^2\ \[Eta]\_1[t]\^2\ \[Eta]\_2[t]\)\/\(\[Omega]\_1\ 
              \[Omega]\_2\%2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) - 
          \(\[Delta]\^2\ \[Eta]\_1[t]\^2\ \[Eta]\&_\_2[t]\)\/\(\[Omega]\_1\ 
              \((\[Omega]\_1 - \[Omega]\_2)\)\ \[Omega]\_2\%2\) + 
          \(\[Delta]\^2\ \[Eta]\_1[t]\ \[Eta]\&_\_1[t]\ 
              \[Eta]\&_\_2[t]\)\/\(\[Omega]\_1\ \[Omega]\_2\%2\ 
              \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) - 
          \(\[Delta]\^2\ \[Eta]\&_\_1[t]\^2\ 
              \[Eta]\&_\_2[t]\)\/\(\[Omega]\_2\%2\ 
              \((\[Omega]\_1 + \[Omega]\_2)\)\ 
              \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["or in pure function form as", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(hRuleC = 
      Table[{h\_\(i, 2\) -> 
              \((Evaluate[
                    hSolC[\([i, 2]\)] /. 
                      Thread[basicTerms -> {#1, #2, #3, #4}]]\ &)\), 
            h\&_\_\(i, 2\) -> 
              \((Evaluate[
                    \(hSolC[\([i, 2]\)] /. conjugateRule\) /. 
                      Thread[basicTerms -> {#1, #2, #3, #4}]]\ &)\)}, {i, 
            2}] // Flatten; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Choosing the ",
  Cell[BoxData[
      \(TraditionalForm\`g\_\(i, 2\)\)]],
  " to eliminate the resonance terms from ",
  StyleBox["order3expr",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(gRuleC = 
      Table[g\_\(i, 2\)[t] -> 
          \(-\ Coefficient[order3expr[\([i]\)], ResonantCTerm[i]] . 
              ResonantCTerm[i]\), {i, 2}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({g\_\(1, 2\)[t] \[Rule] 
        \(-\((\(2\ I\ \[Delta]\^2\)\/\(\[Omega]\_1\ \[Omega]\_2\%2\) + 
                  \(I\ \[Delta]\^2\)\/\(2\ \[Omega]\_1\ \[Omega]\_2\ 
                      \((2\ \[Omega]\_1 + \[Omega]\_2)\)\))\)\)\ 
            \[Eta]\_1[t]\^2\ \[Eta]\&_\_1[t] - 
          \(I\ \[Delta]\^2\ \[Eta]\_1[t]\ \[Eta]\_2[t]\ 
              \[Eta]\&_\_2[t]\)\/\(\[Omega]\_1\%2\ 
              \((2\ \[Omega]\_1 + \[Omega]\_2)\)\), 
      g\_\(2, 2\)[t] \[Rule] 
        \(-\(\(I\ \[Delta]\^2\ \[Eta]\_1[t]\ \[Eta]\_2[t]\ 
                \[Eta]\&_\_1[t]\)\/\(\[Omega]\_1\ \[Omega]\_2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Combining ",
  StyleBox["etaRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", ",
  StyleBox["gRuleQ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", and ",
  StyleBox["gRuleC ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "and letting ",
  Cell[BoxData[
      \(TraditionalForm\`\[Eta]\_i = A\_i[t]\ E\^\(I\ \[Omega]\_i\ t\)\)]],
  ", we obtain the modulation equation"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(moduEq = 
      Table[\(2\ I\ \[Omega]\_k\ \(E\^\(\(-I\)\ \[Omega]\_k\ t\)\) 
                  \((\(\[Eta]\_k\^\[Prime]\)[t] - 
                      \((\(\(\(\[Eta]\_k\^\[Prime]\)[t] /. etaRule\) /. gRuleQ
                            \) /. gRuleC)\))\) == 0 /. {
                \[Eta]\_i_ -> \((A\_i[#]\ E\^\(I\ \[Omega]\_i\ #\)&)\), 
                \[Eta]\&_\_i_ -> 
                  \((A\&_\_i[#]\ E\^\(\(-I\)\ \[Omega]\_i\ #\)&)\)}\) /. 
            Exp[a_] :> 
              Exp[a /. 
                    \[Omega]\_2 -> 
                      2  \[Omega]\_1 + \(\[Epsilon]\^2\) \[Sigma] // 
                  Expand] // ExpandAll, {k, 2}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
          \(-\(\(4\ \[Delta]\^2\ \[Epsilon]\^2\ A\_1[t]\^2\ 
                    A\&_\_1[t]\)\/\[Omega]\_2\%2\)\), "-", 
            \(\(2\ \[Delta]\^2\ \[Epsilon]\^2\ \[Omega]\_1\ A\_1[t]\^2\ 
                  A\&_\_1[t]\)\/\(4\ \[Omega]\_1\%2\ \[Omega]\_2 + 
                  2\ \[Omega]\_1\ \[Omega]\_2\%2\)\), "-", 
            \(2\ E\^\(I\ t\ \[Epsilon]\^2\ \[Sigma]\)\ \[Delta]\ \[Epsilon]\ 
              A\_2[t]\ A\&_\_1[t]\), "-", 
            \(\(2\ \[Delta]\^2\ \[Epsilon]\^2\ \[Omega]\_1\ A\_1[t]\ A\_2[t]\ 
                  A\&_\_2[t]\)\/\(2\ \[Omega]\_1\%3 + 
                  \[Omega]\_1\%2\ \[Omega]\_2\)\), "+", 
            RowBox[{"2", " ", "I", " ", \(\[Omega]\_1\), " ", 
              RowBox[{
                SubsuperscriptBox["A", "1", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}]}], "==", "0"}], 
        ",", 
        RowBox[{
          RowBox[{
          \(\(-E\^\(\(-I\)\ t\ \[Epsilon]\^2\ \[Sigma]\)\)\ \[Delta]\ 
              \[Epsilon]\ A\_1[t]\^2\), "-", 
            \(\(2\ \[Delta]\^2\ \[Epsilon]\^2\ \[Omega]\_2\ A\_1[t]\ A\_2[t]\ 
                  A\&_\_1[t]\)\/\(2\ \[Omega]\_1\%2\ \[Omega]\_2 + 
                  \[Omega]\_1\ \[Omega]\_2\%2\)\), "+", 
            RowBox[{"2", " ", "I", " ", \(\[Omega]\_2\), " ", 
              RowBox[{
                SubsuperscriptBox["A", "2", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}]}], "==", 
          "0"}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Using ",
  StyleBox["zetaRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", ",
  StyleBox["hRuleQ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", and ",
  StyleBox["hRuleC",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain the following second-order uniform expansion of the solution \
of ",
  StyleBox["EOM3",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ":"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(solution = 
      Table[u\_k[t] == 
          Collect[\(\(\[Zeta]\_k[t] + \[Zeta]\&_\_k[t] /. zetaRule\) /. hRuleQ
                \) /. hRuleC, \[Epsilon]], {k, 2}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_1[t] == 
        \[Epsilon]\ \((\[Eta]\_1[t] + \[Eta]\&_\_1[t])\) + 
          \[Epsilon]\^2\ 
            \((\(-\(\(\[Delta]\ \[Eta]\_1[t]\ \[Eta]\_2[t]\)\/\(\[Omega]\_1\ 
                        \[Omega]\_2\)\)\) + 
                \(\[Delta]\ \[Eta]\_1[t]\ \[Eta]\_2[t]\)\/\(\[Omega]\_1\ 
                    \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
                \(\[Delta]\ \[Eta]\_2[t]\ \[Eta]\&_\_1[t]\)\/\(\[Omega]\_1\ 
                    \[Omega]\_2\) + 
                \(\[Delta]\ \[Eta]\_1[t]\ \[Eta]\&_\_2[t]\)\/\(\[Omega]\_1\ 
                    \[Omega]\_2\) - 
                \(\[Delta]\ \[Eta]\&_\_1[t]\ 
                    \[Eta]\&_\_2[t]\)\/\(\[Omega]\_1\ \[Omega]\_2\) + 
                \(\[Delta]\ \[Eta]\&_\_1[t]\ 
                    \[Eta]\&_\_2[t]\)\/\(\[Omega]\_1\ 
                    \((2\ \[Omega]\_1 + \[Omega]\_2)\)\))\) + 
          \[Epsilon]\^3\ 
            \((\(\[Delta]\^2\ \[Eta]\_1[t]\^3\)\/\(4\ \[Omega]\_1\%2\ 
                    \[Omega]\_2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) - 
                \(\((\[Delta]\^2\ \[Omega]\_1 + \[Delta]\^2\ \[Omega]\_2)\)\ 
                    \[Eta]\_1[t]\^3\)\/\(2\ \[Omega]\_1\%2\ \[Omega]\_2\%2\ 
                    \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
                \(\[Delta]\^2\ \[Eta]\_1[t]\ 
                    \[Eta]\_2[t]\^2\)\/\(\[Omega]\_1\ \[Omega]\_2\%2\ 
                    \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) - 
                \(\[Delta]\^2\ \[Eta]\_1[t]\ 
                    \[Eta]\_2[t]\^2\)\/\(\[Omega]\_1\ \[Omega]\_2\ 
                    \((\[Omega]\_1 + \[Omega]\_2)\)\ 
                    \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) - 
                \(\((\(-5\)\ \[Delta]\^2\ \[Omega]\_1 - 
                        3\ \[Delta]\^2\ \[Omega]\_2)\)\ \[Eta]\_1[t]\^2\ 
                    \[Eta]\&_\_1[t]\)\/\(2\ \[Omega]\_1\%2\ \[Omega]\_2\%2\ 
                    \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
                \(\[Delta]\^2\ \[Eta]\_2[t]\^2\ 
                    \[Eta]\&_\_1[t]\)\/\(\[Omega]\_1\%2\ 
                    \((\[Omega]\_1 - \[Omega]\_2)\)\ \[Omega]\_2\) - 
                \(\((\(-\[Delta]\^2\)\ \[Omega]\_1 - \[Delta]\^2\ \[Omega]\_2)
                      \)\ \[Eta]\_2[t]\^2\ 
                    \[Eta]\&_\_1[t]\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\%2\ 
                    \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) - 
                \(\((\(-5\)\ \[Delta]\^2\ \[Omega]\_1 - 
                        3\ \[Delta]\^2\ \[Omega]\_2)\)\ \[Eta]\_1[t]\ 
                    \[Eta]\&_\_1[t]\^2\)\/\(2\ \[Omega]\_1\%2\ 
                    \[Omega]\_2\%2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
                \(\[Delta]\^2\ \[Eta]\&_\_1[t]\^3\)\/\(4\ \[Omega]\_1\%2\ 
                    \[Omega]\_2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) - 
                \(\((\[Delta]\^2\ \[Omega]\_1 + \[Delta]\^2\ \[Omega]\_2)\)\ 
                    \[Eta]\&_\_1[t]\^3\)\/\(2\ \[Omega]\_1\%2\ 
                    \[Omega]\_2\%2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) - 
                \(\[Delta]\^2\ \[Eta]\_1[t]\ \[Eta]\_2[t]\ 
                    \[Eta]\&_\_2[t]\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\ 
                    \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) - 
                \(\[Delta]\^2\ \[Eta]\_2[t]\ \[Eta]\&_\_1[t]\ 
                    \[Eta]\&_\_2[t]\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\ 
                    \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
                \(\[Delta]\^2\ \[Eta]\_1[t]\ 
                    \[Eta]\&_\_2[t]\^2\)\/\(\[Omega]\_1\%2\ 
                    \((\[Omega]\_1 - \[Omega]\_2)\)\ \[Omega]\_2\) - 
                \(\((\(-\[Delta]\^2\)\ \[Omega]\_1 - \[Delta]\^2\ \[Omega]\_2)
                      \)\ \[Eta]\_1[t]\ 
                    \[Eta]\&_\_2[t]\^2\)\/\(\[Omega]\_1\%2\ \[Omega]\_2\%2\ 
                    \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
                \(\[Delta]\^2\ \[Eta]\&_\_1[t]\ 
                    \[Eta]\&_\_2[t]\^2\)\/\(\[Omega]\_1\ \[Omega]\_2\%2\ 
                    \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) - 
                \(\[Delta]\^2\ \[Eta]\&_\_1[t]\ 
                    \[Eta]\&_\_2[t]\^2\)\/\(\[Omega]\_1\ \[Omega]\_2\ 
                    \((\[Omega]\_1 + \[Omega]\_2)\)\ 
                    \((2\ \[Omega]\_1 + \[Omega]\_2)\)\))\), 
      u\_2[t] == 
        \[Epsilon]\^2\ 
            \((\(\[Delta]\ \[Eta]\_1[t]\^2\)\/\(2\ \[Omega]\_2\ 
                    \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
                \(2\ \[Delta]\ \[Eta]\_1[t]\ \[Eta]\&_\_1[t]\)\/\[Omega]\_2
                    \%2 + \(\[Delta]\ \[Eta]\&_\_1[t]\^2\)\/\(2\ \[Omega]\_2\ 
                    \((2\ \[Omega]\_1 + \[Omega]\_2)\)\))\) + 
          \[Epsilon]\ \((\[Eta]\_2[t] + \[Eta]\&_\_2[t])\) + 
          \[Epsilon]\^3\ 
            \((\(\[Delta]\^2\ \[Eta]\_1[t]\^2\ \[Eta]\_2[t]\)\/\(\[Omega]\_1\ 
                    \[Omega]\_2\%2\ \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) - 
                \(\[Delta]\^2\ \[Eta]\_1[t]\^2\ 
                    \[Eta]\_2[t]\)\/\(\[Omega]\_2\%2\ 
                    \((\[Omega]\_1 + \[Omega]\_2)\)\ 
                    \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
                \(\[Delta]\^2\ \[Eta]\_1[t]\ \[Eta]\_2[t]\ 
                    \[Eta]\&_\_1[t]\)\/\(\[Omega]\_1\ \[Omega]\_2\%2\ 
                    \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) - 
                \(\[Delta]\^2\ \[Eta]\_2[t]\ 
                    \[Eta]\&_\_1[t]\^2\)\/\(\[Omega]\_1\ 
                    \((\[Omega]\_1 - \[Omega]\_2)\)\ \[Omega]\_2\%2\) - 
                \(\[Delta]\^2\ \[Eta]\_1[t]\^2\ 
                    \[Eta]\&_\_2[t]\)\/\(\[Omega]\_1\ 
                    \((\[Omega]\_1 - \[Omega]\_2)\)\ \[Omega]\_2\%2\) + 
                \(\[Delta]\^2\ \[Eta]\_1[t]\ \[Eta]\&_\_1[t]\ 
                    \[Eta]\&_\_2[t]\)\/\(\[Omega]\_1\ \[Omega]\_2\%2\ 
                    \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
                \(\[Delta]\^2\ \[Eta]\&_\_1[t]\^2\ 
                    \[Eta]\&_\_2[t]\)\/\(\[Omega]\_1\ \[Omega]\_2\%2\ 
                    \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) - 
                \(\[Delta]\^2\ \[Eta]\&_\_1[t]\^2\ 
                    \[Eta]\&_\_2[t]\)\/\(\[Omega]\_2\%2\ 
                    \((\[Omega]\_1 + \[Omega]\_2)\)\ 
                    \((2\ \[Omega]\_1 + \[Omega]\_2)\)\))\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["5.4 Generalized Method of Averaging ", "Section",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "We define the nonlinear part of ",
  StyleBox["EOM1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", a transformation rule, and the states vector as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(NLTerms = {f\_1 -> 2\ \[Epsilon]\ \[Delta]\ u\_1[t]\ u\_2[t], 
        f\_2 -> \[Epsilon]\ \[Delta]\ u\_1[t]\^2}; \n
    transformRule = u\_i_ -> \((a\_i[#]\ Sin[\[Phi]\_i[#]]\ &)\); \n
    states = {a\_1[t], a\_2[t], \[Phi]\_1[t], \[Phi]\_2[t]}; \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
Substituting the above rules into the four first-order equations obtained by \
using the method of variation of parameters, we have\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq54a = 
      D[states, t] == 
          \((\(\({f\_1\/\[Omega]\_1\ Cos[\[Phi]\_1[t]], 
                      \(f\_2\/\[Omega]\_2\) Cos[\[Phi]\_2[t]], 
                      \[Omega]\_1 - 
                        f\_1\/\(a\_1[t]\ \[Omega]\_1\)\ Sin[\[Phi]\_1[t]], 
                      \[Omega]\_2 - 
                        f\_2\/\(a\_2[t]\ \[Omega]\_2\)\ Sin[\[Phi]\_2[t]]} /. 
                    NLTerms\) /. transformRule // TrigReduce\) // Expand)
            \) // Thread\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SubsuperscriptBox["a", "1", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", 
          \(\(\[Delta]\ \[Epsilon]\ Cos[2\ \[Phi]\_1[t] - \[Phi]\_2[t]]\ 
                a\_1[t]\ a\_2[t]\)\/\(2\ \[Omega]\_1\) - 
            \(\[Delta]\ \[Epsilon]\ Cos[2\ \[Phi]\_1[t] + \[Phi]\_2[t]]\ 
                a\_1[t]\ a\_2[t]\)\/\(2\ \[Omega]\_1\)\)}], ",", 
        RowBox[{
          RowBox[{
            SubsuperscriptBox["a", "2", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", 
          \(\(-\(\(\[Delta]\ \[Epsilon]\ Cos[2\ \[Phi]\_1[t] - \[Phi]\_2[t]]\ 
                    a\_1[t]\^2\)\/\(4\ \[Omega]\_2\)\)\) + 
            \(\[Delta]\ \[Epsilon]\ Cos[\[Phi]\_2[t]]\ a\_1[t]\^2\)\/\(2\ 
                \[Omega]\_2\) - 
            \(\[Delta]\ \[Epsilon]\ Cos[2\ \[Phi]\_1[t] + \[Phi]\_2[t]]\ 
                a\_1[t]\^2\)\/\(4\ \[Omega]\_2\)\)}], ",", 
        RowBox[{
          RowBox[{
            SubsuperscriptBox["\[Phi]", "1", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", 
          \(\[Omega]\_1 - 
            \(\[Delta]\ \[Epsilon]\ Sin[2\ \[Phi]\_1[t] - \[Phi]\_2[t]]\ 
                a\_2[t]\)\/\(2\ \[Omega]\_1\) - 
            \(\[Delta]\ \[Epsilon]\ Sin[\[Phi]\_2[t]]\ 
                a\_2[t]\)\/\[Omega]\_1 + 
            \(\[Delta]\ \[Epsilon]\ Sin[2\ \[Phi]\_1[t] + \[Phi]\_2[t]]\ 
                a\_2[t]\)\/\(2\ \[Omega]\_1\)\)}], ",", 
        RowBox[{
          RowBox[{
            SubsuperscriptBox["\[Phi]", "2", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", 
          \(\[Omega]\_2 - 
            \(\[Delta]\ \[Epsilon]\ Sin[2\ \[Phi]\_1[t] - \[Phi]\_2[t]]\ 
                a\_1[t]\^2\)\/\(4\ \[Omega]\_2\ a\_2[t]\) - 
            \(\[Delta]\ \[Epsilon]\ Sin[\[Phi]\_2[t]]\ a\_1[t]\^2\)\/\(2\ 
                \[Omega]\_2\ a\_2[t]\) + 
            \(\[Delta]\ \[Epsilon]\ Sin[2\ \[Phi]\_1[t] + \[Phi]\_2[t]]\ 
                a\_1[t]\^2\)\/\(4\ \[Omega]\_2\ a\_2[t]\)\)}]}], "}"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "We seek a second-order approximate solution of ",
  StyleBox["eq54a",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in the form"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(basicTerms = {\[Eta]\_1[t], \[Eta]\_2[t], \[CurlyPhi]\_1[t], 
        \[CurlyPhi]\_2[t]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(solRule = {\ 
        a\_i_ -> 
          \((Evaluate[
                \[Eta]\_i[t] + 
                    Sum[\[Epsilon]\^j\ 
                        a\_\(i, j\)[Sequence\ @@\ basicTerms], {j, 2}] /. 
                  t -> #]\ &)\), 
        \[Phi]\_i_ -> 
          \((Evaluate[
                \[CurlyPhi]\_i[t] + 
                    Sum[\[Epsilon]\^j\ 
                        \[Phi]\_\(i, j\)[Sequence\ @@\ basicTerms], {j, 
                        2}] /. t -> #]\ &)\)}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "where the ",
  Cell[BoxData[
      \(TraditionalForm\`\[Eta]\_i[t]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CurlyPhi]\_i[t]\)]],
  " are expanded in power series in \[Epsilon] as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(basicDRule = 
      D[basicTerms, t] -> {
            Sum[\[Epsilon]\^i\ A\_\(1, i\)[\[Eta]\_1[t], \[Eta]\_2[t]], {i, 
                2}], Sum[
              \[Epsilon]\^i\ A\_\(2, i\)[\[Eta]\_1[t], \[Eta]\_2[t]], {i, 
                2}], \[Omega]\_1 + 
              Sum[\[Epsilon]\^i\ 
                  \[CapitalPhi]\_\(1, i\)[\[Eta]\_1[t], \[Eta]\_2[t]], {i, 
                  2}], \[Omega]\_2 + 
              Sum[\[Epsilon]\^i\ 
                  \[CapitalPhi]\_\(2, i\)[\[Eta]\_1[t], \[Eta]\_2[t]], {i, 
                  2}]} // Thread\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SubsuperscriptBox["\[Eta]", "1", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "\[Rule]", 
          \(\[Epsilon]\ A\_\(1, 1\)[\[Eta]\_1[t], \[Eta]\_2[t]] + 
            \[Epsilon]\^2\ A\_\(1, 2\)[\[Eta]\_1[t], \[Eta]\_2[t]]\)}], ",", 
        RowBox[{
          RowBox[{
            SubsuperscriptBox["\[Eta]", "2", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "\[Rule]", 
          \(\[Epsilon]\ A\_\(2, 1\)[\[Eta]\_1[t], \[Eta]\_2[t]] + 
            \[Epsilon]\^2\ A\_\(2, 2\)[\[Eta]\_1[t], \[Eta]\_2[t]]\)}], ",", 
        RowBox[{
          RowBox[{
            SubsuperscriptBox["\[CurlyPhi]", "1", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "\[Rule]", 
          \(\[Omega]\_1 + 
            \[Epsilon]\ \[CapitalPhi]\_\(1, 1\)[\[Eta]\_1[t], \[Eta]\_2[t]] + 
            \[Epsilon]\^2\ 
              \[CapitalPhi]\_\(1, 2\)[\[Eta]\_1[t], \[Eta]\_2[t]]\)}], ",", 
        RowBox[{
          RowBox[{
            SubsuperscriptBox["\[CurlyPhi]", "2", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "\[Rule]", 
          \(\[Omega]\_2 + 
            \[Epsilon]\ \[CapitalPhi]\_\(2, 1\)[\[Eta]\_1[t], \[Eta]\_2[t]] + 
            \[Epsilon]\^2\ 
              \[CapitalPhi]\_\(2, 2\)[\[Eta]\_1[t], \[Eta]\_2[t]]\)}]}], 
      "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The functions ",
  Cell[BoxData[
      \(TraditionalForm\`a\_\(i, \ j\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_\(i, \ j\)\)]],
  " are fast varying functions of the ",
  Cell[BoxData[
      \(TraditionalForm\`\[CurlyPhi]\_i\)]],
  ", while it follows from ",
  StyleBox["basicDRule ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "that the ",
  Cell[BoxData[
      \(TraditionalForm\`\[Eta]\_i\)]],
  ", and hence the ",
  Cell[BoxData[
      \(TraditionalForm\`A\_\(i, \ j\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi]\_\(i, \ j\)\)]],
  ", are slowly varying functions of ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "To the second approximation, we differentiate the ",
  Cell[BoxData[
      \(TraditionalForm\`a\_i[t]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_i[t]\)]],
  " once with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ", use ",
  StyleBox["solRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["basicDRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", expand the result for small \[Epsilon], discard terms of order higher \
than ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon]\^2\)]],
  ", and obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eq54bLHS = 
      \(CoefficientList[
            Expand[\(#[\([1]\)] /. solRule\) /. basicDRule] /. 
              \[Epsilon]\^\(n_ /; n > 2\) -> 0, \[Epsilon]]\ &\)\ /@\ eq54a; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Next, we substitute ",
  StyleBox["solRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into the right-hand sides of ",
  StyleBox["eq54a",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", expand the result for small \[Epsilon], keep terms up to ",
  Cell[BoxData[
      \(TraditionalForm\`O(\[Epsilon]\^2)\)]],
  ", and rewrite their right-hand sides as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eq54bRHS = 
      \(CoefficientList[
            Series[#[\([2]\)] /. solRule, {\[Epsilon], 0, 2}] // Normal, 
            \[Epsilon]]\ &\)\ /@\ eq54a; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Equating coefficients of like powers of \[Epsilon] in ",
  StyleBox["eq54bLHS",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["eq54bRHS",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eqEps = 
      \(MapThread[Equal, {eq54bLHS, eq54bRHS}, 2] // Transpose\) // Rest; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[
"To express the nearness of the two-to-one internal resonance, we introduce \
the detuning parameter \[Sigma] defined according to"], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(omgRule = {\[Omega]\_2 -> 2  \[Omega]\_1 + \[Epsilon]\ \[Sigma]}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Hence, \[Sigma] can be related to the ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_i\)]],
  " by"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sigRule = \(Solve[omgRule /. Rule -> Equal, \[Sigma]]\)[\([1]\)]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Sigma] \[Rule] \(-\(\(2\ \[Omega]\_1 - \[Omega]\_2\)\/\[Epsilon]\)\)}
      \)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
To use the method of averaging, we define the following rules:\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(psiRule = {\[CurlyPhi]\_1[t] -> \[Omega]\_1\ t + \[Beta]\_1, 
        \[CurlyPhi]\_2[t] -> \[Omega]\_2\ t + \[Beta]\_2}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(betaRule = 
      \(Solve[psiRule /. Rule -> Equal, {\[Beta]\_1, \[Beta]\_2}]\)[\([1]\)]
        \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Beta]\_1 \[Rule] \(-t\)\ \[Omega]\_1 + \[CurlyPhi]\_1[t], 
      \[Beta]\_2 \[Rule] \(-t\)\ \[Omega]\_2 + \[CurlyPhi]\_2[t]}\)], "Output",\

  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[BoxData[
    \(\(expRule1 = 
      f_[a_] :> 
        f[Expand[\(a /. psiRule\) /. omgRule] /. \[Epsilon]\ t -> t\_1]; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(expRule2 = 
      f_[a_] :> 
        f[Expand[\(\(a /. t\_1 -> \[Epsilon]\ t\) /. sigRule\) /. betaRule]]; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Next, we separate the fast and slowly varying terms in the first-order \
equations, ",
  StyleBox["eqEps[[1]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ". To this end, we define a slow state vector and a fast state vector \
according to"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[{
    \(SVT[j_] := {A\_\(1, j\)[\[Eta]\_1[t], \[Eta]\_2[t]], 
        A\_\(2, j\)[\[Eta]\_1[t], \[Eta]\_2[t]], 
        \[CapitalPhi]\_\(1, j\)[\[Eta]\_1[t], \[Eta]\_2[t]], 
        \[CapitalPhi]\_\(2, j\)[\[Eta]\_1[t], \[Eta]\_2[t]]}\), 
    \(solVar[j_] := {a\_\(1, j\), a\_\(2, j\), \[Phi]\_\(1, j\), 
        \[Phi]\_\(2, j\)}\)}], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Then, the slowly varying parts of ",
  StyleBox["eqEps[[1]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " are given by"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(SVT1Rule = 
      Table[\(Solve[
              \(\(\(\(eqEps[\([1, i]\)] /. 
                        Thread[solVar[1] -> \((0\ &)\)]\) /. expRule1\) /. 
                    f_[_\ t + _. ] -> 0\) /. expRule2\) /. 
                f_[a_] :> f[Expand[a]], \(SVT[1]\)[\([i]\)]]\)\ [\([1]\)], {
            i, 4}] // Flatten\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({A\_\(1, 1\)[\[Eta]\_1[t], \[Eta]\_2[t]] \[Rule] 
        \(\[Delta]\ Cos[2\ \[CurlyPhi]\_1[t] - \[CurlyPhi]\_2[t]]\ 
            \[Eta]\_1[t]\ \[Eta]\_2[t]\)\/\(2\ \[Omega]\_1\), 
      A\_\(2, 1\)[\[Eta]\_1[t], \[Eta]\_2[t]] \[Rule] 
        \(-\(\(\[Delta]\ Cos[2\ \[CurlyPhi]\_1[t] - \[CurlyPhi]\_2[t]]\ 
                \[Eta]\_1[t]\^2\)\/\(4\ \[Omega]\_2\)\)\), 
      \[CapitalPhi]\_\(1, 1\)[\[Eta]\_1[t], \[Eta]\_2[t]] \[Rule] 
        \(-\(\(\[Delta]\ Sin[2\ \[CurlyPhi]\_1[t] - \[CurlyPhi]\_2[t]]\ 
                \[Eta]\_2[t]\)\/\(2\ \[Omega]\_1\)\)\), 
      \[CapitalPhi]\_\(2, 1\)[\[Eta]\_1[t], \[Eta]\_2[t]] \[Rule] 
        \(-\(\(\[Delta]\ Sin[2\ \[CurlyPhi]\_1[t] - \[CurlyPhi]\_2[t]]\ 
                \[Eta]\_1[t]\^2\)\/\(4\ \[Omega]\_2\ \[Eta]\_2[t]\)\)\)}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["whereas the fast varying parts are given by", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(FVT1 = 
      Table[Subtract\ @@\ eqEps[\([1, i]\)] /. 
            Thread[solVar[1] -> \((0\ &)\)], {i, 4}] /. SVT1Rule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\(\[Delta]\ Cos[2\ \[CurlyPhi]\_1[t] + \[CurlyPhi]\_2[t]]\ 
          \[Eta]\_1[t]\ \[Eta]\_2[t]\)\/\(2\ \[Omega]\_1\), 
      \(-\(\(\[Delta]\ Cos[\[CurlyPhi]\_2[t]]\ \[Eta]\_1[t]\^2\)\/\(2\ 
                \[Omega]\_2\)\)\) + 
        \(\[Delta]\ Cos[2\ \[CurlyPhi]\_1[t] + \[CurlyPhi]\_2[t]]\ 
            \[Eta]\_1[t]\^2\)\/\(4\ \[Omega]\_2\), 
      \(\[Delta]\ Sin[\[CurlyPhi]\_2[t]]\ \[Eta]\_2[t]\)\/\[Omega]\_1 - 
        \(\[Delta]\ Sin[2\ \[CurlyPhi]\_1[t] + \[CurlyPhi]\_2[t]]\ 
            \[Eta]\_2[t]\)\/\(2\ \[Omega]\_1\), 
      \(\[Delta]\ Sin[\[CurlyPhi]\_2[t]]\ \[Eta]\_1[t]\^2\)\/\(2\ 
            \[Omega]\_2\ \[Eta]\_2[t]\) - 
        \(\[Delta]\ Sin[2\ \[CurlyPhi]\_1[t] + \[CurlyPhi]\_2[t]]\ 
            \[Eta]\_1[t]\^2\)\/\(4\ \[Omega]\_2\ \[Eta]\_2[t]\)}\)], "Output",\

  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
To determine the solution corresponding to these fast varying terms, we use \
the method of undetermined coefficients. To accomplish this, we first \
identify the possible forms of the nonhomogeneous terms. The result is\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(FVT1Forms = 
      \(Flatten[Cases[#, \((Cos | Sin)\)[a_] -> {Cos[a], Sin[a]}, Infinity]]
            \ &\)\ /@\ FVT1\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{Cos[2\ \[CurlyPhi]\_1[t] + \[CurlyPhi]\_2[t]], 
        Sin[2\ \[CurlyPhi]\_1[t] + \[CurlyPhi]\_2[t]]}, {
        Cos[\[CurlyPhi]\_2[t]], Sin[\[CurlyPhi]\_2[t]], 
        Cos[2\ \[CurlyPhi]\_1[t] + \[CurlyPhi]\_2[t]], 
        Sin[2\ \[CurlyPhi]\_1[t] + \[CurlyPhi]\_2[t]]}, {
        Cos[\[CurlyPhi]\_2[t]], Sin[\[CurlyPhi]\_2[t]], 
        Cos[2\ \[CurlyPhi]\_1[t] + \[CurlyPhi]\_2[t]], 
        Sin[2\ \[CurlyPhi]\_1[t] + \[CurlyPhi]\_2[t]]}, {
        Cos[\[CurlyPhi]\_2[t]], Sin[\[CurlyPhi]\_2[t]], 
        Cos[2\ \[CurlyPhi]\_1[t] + \[CurlyPhi]\_2[t]], 
        Sin[2\ \[CurlyPhi]\_1[t] + \[CurlyPhi]\_2[t]]}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
The fast-varying component of the first-order solution can be expressed as a \
linear combination of these forms; that is,\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1Form = 
      MapIndexed[\((coeffs1[#2[\([1]\)]] = Array[c, Length[#1]])\) . #1\ &, 
        FVT1Forms]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({c[1]\ Cos[2\ \[CurlyPhi]\_1[t] + \[CurlyPhi]\_2[t]] + 
        c[2]\ Sin[2\ \[CurlyPhi]\_1[t] + \[CurlyPhi]\_2[t]], 
      c[1]\ Cos[\[CurlyPhi]\_2[t]] + 
        c[3]\ Cos[2\ \[CurlyPhi]\_1[t] + \[CurlyPhi]\_2[t]] + 
        c[2]\ Sin[\[CurlyPhi]\_2[t]] + 
        c[4]\ Sin[2\ \[CurlyPhi]\_1[t] + \[CurlyPhi]\_2[t]], 
      c[1]\ Cos[\[CurlyPhi]\_2[t]] + 
        c[3]\ Cos[2\ \[CurlyPhi]\_1[t] + \[CurlyPhi]\_2[t]] + 
        c[2]\ Sin[\[CurlyPhi]\_2[t]] + 
        c[4]\ Sin[2\ \[CurlyPhi]\_1[t] + \[CurlyPhi]\_2[t]], 
      c[1]\ Cos[\[CurlyPhi]\_2[t]] + 
        c[3]\ Cos[2\ \[CurlyPhi]\_1[t] + \[CurlyPhi]\_2[t]] + 
        c[2]\ Sin[\[CurlyPhi]\_2[t]] + 
        c[4]\ Sin[2\ \[CurlyPhi]\_1[t] + \[CurlyPhi]\_2[t]]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Substituting ",
  StyleBox["sol1Form",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["eqEps[[1]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", using ",
  StyleBox["SVT1Rule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", collecting the coefficients of ",
  StyleBox["FVT1Forms",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", solving the resulting algebraic equation for the undetermined \
coefficients, and then substituting the result back into ",
  StyleBox["sol1Form",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1rhs = 
      Table[sol1Form[\([i]\)] /. 
          \(Solve[Coefficient[
                    \(Subtract\ @@\ eqEps[\([1, i]\)] /. SVT1Rule\) /. 
                      \(solVar[1]\)[\([i]\)] -> 
                        \((Evaluate[
                              sol1Form[\([i]\)] /. 
                                Thread[basicTerms -> {#1, #2, #3, #4}]]\ &)
                          \), FVT1Forms[\([i]\)]] == 0 // Thread, coeffs1[i]]
              \)[\([1]\)], {i, 4}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\(-
        \(\(\[Delta]\ Sin[2\ \[CurlyPhi]\_1[t] + \[CurlyPhi]\_2[t]]\ 
              \[Eta]\_1[t]\ \[Eta]\_2[t]\)\/\(2\ \[Omega]\_1\ 
              \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)\), 
      \(\[Delta]\ Sin[\[CurlyPhi]\_2[t]]\ \[Eta]\_1[t]\^2\)\/\(2\ 
            \[Omega]\_2\%2\) - 
        \(\[Delta]\ Sin[2\ \[CurlyPhi]\_1[t] + \[CurlyPhi]\_2[t]]\ 
            \[Eta]\_1[t]\^2\)\/\(4\ \[Omega]\_2\ 
            \((2\ \[Omega]\_1 + \[Omega]\_2)\)\), 
      \(\[Delta]\ Cos[\[CurlyPhi]\_2[t]]\ \[Eta]\_2[t]\)\/\(\[Omega]\_1\ 
            \[Omega]\_2\) - 
        \(\[Delta]\ Cos[2\ \[CurlyPhi]\_1[t] + \[CurlyPhi]\_2[t]]\ 
            \[Eta]\_2[t]\)\/\(2\ \[Omega]\_1\ 
            \((2\ \[Omega]\_1 + \[Omega]\_2)\)\), 
      \(\[Delta]\ Cos[\[CurlyPhi]\_2[t]]\ \[Eta]\_1[t]\^2\)\/\(2\ 
            \[Omega]\_2\%2\ \[Eta]\_2[t]\) - 
        \(\[Delta]\ Cos[2\ \[CurlyPhi]\_1[t] + \[CurlyPhi]\_2[t]]\ 
            \[Eta]\_1[t]\^2\)\/\(4\ \[Omega]\_2\ 
            \((2\ \[Omega]\_1 + \[Omega]\_2)\)\ \[Eta]\_2[t]\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["or in a pure function form as", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1Rule = 
      Table[\(solVar[1]\)[\([i]\)] -> 
          \((Evaluate[
                sol1rhs[\([i]\)] /. Thread[basicTerms -> {#1, #2, #3, #4}]]
                \ &)\), {i, 4}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({a\_\(1, 1\) \[Rule] 
        \((\(-\(\(\[Delta]\ Sin[2\ #3 + #4]\ #1\ #2\)\/\(2\ \[Omega]\_1\ 
                    \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)\)&)\), 
      a\_\(2, 1\) \[Rule] 
        \((\(\[Delta]\ Sin[#4]\ #1\^2\)\/\(2\ \[Omega]\_2\%2\) - 
              \(\[Delta]\ Sin[2\ #3 + #4]\ #1\^2\)\/\(4\ \[Omega]\_2\ 
                  \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)&)\), 
      \[Phi]\_\(1, 1\) \[Rule] 
        \((\(\[Delta]\ Cos[#4]\ #2\)\/\(\[Omega]\_1\ \[Omega]\_2\) - 
              \(\[Delta]\ Cos[2\ #3 + #4]\ #2\)\/\(2\ \[Omega]\_1\ 
                  \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)&)\), 
      \[Phi]\_\(2, 1\) \[Rule] 
        \((\(\[Delta]\ Cos[#4]\ #1\^2\)\/\(2\ #2\ \[Omega]\_2\%2\) - 
              \(\[Delta]\ Cos[2\ #3 + #4]\ #1\^2\)\/\(4\ #2\ \[Omega]\_2\ 
                  \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)&)\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Substituting the slow- and fast-varying components of the first-order \
solution, ",
  StyleBox["SVT1Rule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["sol1Rule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", into the second-order equations, we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((order2Expr = 
          Table[\(\(Subtract\ @@\ eqEps[\([2, i]\)] /. SVT1Rule\) /. 
                  sol1Rule // Expand\) // TrigReduce, {i, 4}]; )\) // Timing
      \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({5.74799999999959254`\ Second, Null}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Since we are seeking an expansion valid up to ",
  Cell[BoxData[
      \(TraditionalForm\`O(\[Epsilon]\^2)\)]],
  ", we do not need to solve for the ",
  Cell[BoxData[
      \(TraditionalForm\`a\_\(i, \ 2\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_\(i, \ 2\)\)]],
  ". All we need to do is to investigate the above expressions to determine \
the slowly varying parts and hence determine the ",
  Cell[BoxData[
      \(TraditionalForm\`A\_\(i, \ 2\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi]\_\(i, \ 2\)\)]],
  ". The result is"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(SVT2Rule = 
      Table[Solve[
            \(\(\(\(order2Expr[\([i]\)] == 0 /. 
                      Thread[solVar[2] -> \((0\ &)\)]\) /. expRule1\) /. 
                  f_[_\ t + _. ] -> 0\) /. expRule2\) /. 
              f_[a_] :> f[Expand[a]], \(SVT[2]\)[\([i]\)]], {i, 4}] // Flatten
        \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({A\_\(1, 2\)[\[Eta]\_1[t], \[Eta]\_2[t]] \[Rule] 0, 
      A\_\(2, 2\)[\[Eta]\_1[t], \[Eta]\_2[t]] \[Rule] 0, 
      \[CapitalPhi]\_\(1, 2\)[\[Eta]\_1[t], \[Eta]\_2[t]] \[Rule] 
        \(-\(\(8\ \[Delta]\^2\ \[Omega]\_1\%2\ \[Eta]\_1[t]\^2 + 
                5\ \[Delta]\^2\ \[Omega]\_1\ \[Omega]\_2\ \[Eta]\_1[t]\^2 + 
                2\ \[Delta]\^2\ \[Omega]\_2\%2\ \[Eta]\_2[t]\^2\)\/\(8\ 
                \[Omega]\_1\%2\ \[Omega]\_2\%2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)\), 
      \[CapitalPhi]\_\(2, 2\)[\[Eta]\_1[t], \[Eta]\_2[t]] \[Rule] 
        \(-\(\(\[Delta]\^2\ \[Eta]\_1[t]\^2\)\/\(4\ \[Omega]\_1\ \[Omega]\_2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
Hence, we find that, to the second approximation, the solution is given by\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq54c = {u\_1[t], u\_2[t]} == 
          \((\(Normal[
                    Series[\({u\_1[t], u\_2[t]} /. transformRule\) /. 
                        solRule, {\[Epsilon], 0, 1}]] /. sol1Rule // 
                TrigReduce\) // Expand)\) // Thread\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_1[t] == 
        \(2\ Sin[\[CurlyPhi]\_1[t]]\ \[Omega]\_1\ 
              \[Eta]\_1[t]\)\/\(2\ \[Omega]\_1 + \[Omega]\_2\) + 
          \(Sin[\[CurlyPhi]\_1[t]]\ \[Omega]\_2\ 
              \[Eta]\_1[t]\)\/\(2\ \[Omega]\_1 + \[Omega]\_2\) + 
          \(\[Delta]\ \[Epsilon]\ Cos[\[CurlyPhi]\_1[t] - \[CurlyPhi]\_2[t]]\ 
              \[Eta]\_1[t]\ \[Eta]\_2[t]\)\/\(2\ \[Omega]\_1\ 
              \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
          \(\[Delta]\ \[Epsilon]\ Cos[\[CurlyPhi]\_1[t] - \[CurlyPhi]\_2[t]]\ 
              \[Eta]\_1[t]\ \[Eta]\_2[t]\)\/\(\[Omega]\_2\ 
              \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
          \(\[Delta]\ \[Epsilon]\ Cos[\[CurlyPhi]\_1[t] + \[CurlyPhi]\_2[t]]\ 
              \[Eta]\_1[t]\ \[Eta]\_2[t]\)\/\(\[Omega]\_2\ 
              \((2\ \[Omega]\_1 + \[Omega]\_2)\)\), 
      u\_2[t] == 
        \(\[Delta]\ \[Epsilon]\ \[Omega]\_1\ 
              \[Eta]\_1[t]\^2\)\/\(\[Omega]\_2\%2\ 
              \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
          \(\[Delta]\ \[Epsilon]\ \[Eta]\_1[t]\^2\)\/\(2\ \[Omega]\_2\ 
              \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) - 
          \(\[Delta]\ \[Epsilon]\ Cos[2\ \[CurlyPhi]\_1[t]]\ 
              \[Eta]\_1[t]\^2\)\/\(4\ \[Omega]\_2\ 
              \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) + 
          \(2\ Sin[\[CurlyPhi]\_2[t]]\ \[Omega]\_1\ 
              \[Eta]\_2[t]\)\/\(2\ \[Omega]\_1 + \[Omega]\_2\) + 
          \(Sin[\[CurlyPhi]\_2[t]]\ \[Omega]\_2\ 
              \[Eta]\_2[t]\)\/\(2\ \[Omega]\_1 + \[Omega]\_2\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["where the amplitudes and phases are given by", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(ampEqs = 
      \(\(\(\(basicDRule[\([{1, 2}]\)] /. SVT1Rule\) /. SVT2Rule\) /. psiRule
            \) /. f_[a_] :> f[Collect[a, t]]\) /. Rule -> Equal\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SubsuperscriptBox["\[Eta]", "1", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", 
          \(\(\[Delta]\ \[Epsilon]\ 
                Cos[2\ \[Beta]\_1 - \[Beta]\_2 - 
                    t\ \((\(-2\)\ \[Omega]\_1 + \[Omega]\_2)\)]\ 
                \[Eta]\_1[t]\ \[Eta]\_2[t]\)\/\(2\ \[Omega]\_1\)\)}], ",", 
        RowBox[{
          RowBox[{
            SubsuperscriptBox["\[Eta]", "2", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", 
          \(-\(\(\[Delta]\ \[Epsilon]\ 
                  Cos[2\ \[Beta]\_1 - \[Beta]\_2 - 
                      t\ \((\(-2\)\ \[Omega]\_1 + \[Omega]\_2)\)]\ 
                  \[Eta]\_1[t]\^2\)\/\(4\ \[Omega]\_2\)\)\)}]}], "}"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(phaseEqs = 
      \(\(\(\(basicDRule[\([{3, 4}]\)] /. SVT1Rule\) /. SVT2Rule\) /. psiRule
            \) /. f_[a_] :> f[Collect[a, t]]\) /. Rule -> Equal\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SubsuperscriptBox["\[CurlyPhi]", "1", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", 
          \(\[Omega]\_1 - 
            \(\[Delta]\ \[Epsilon]\ 
                Sin[2\ \[Beta]\_1 - \[Beta]\_2 - 
                    t\ \((\(-2\)\ \[Omega]\_1 + \[Omega]\_2)\)]\ 
                \[Eta]\_2[t]\)\/\(2\ \[Omega]\_1\) - 
            \(\[Epsilon]\^2\ 
                \((8\ \[Delta]\^2\ \[Omega]\_1\%2\ \[Eta]\_1[t]\^2 + 
                    5\ \[Delta]\^2\ \[Omega]\_1\ \[Omega]\_2\ 
                      \[Eta]\_1[t]\^2 + 
                    2\ \[Delta]\^2\ \[Omega]\_2\%2\ \[Eta]\_2[t]\^2)\)\)\/\(8
                \ \[Omega]\_1\%2\ \[Omega]\_2\%2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\)\)}], ",", 
        RowBox[{
          RowBox[{
            SubsuperscriptBox["\[CurlyPhi]", "2", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", 
          \(\[Omega]\_2 - 
            \(\[Delta]\^2\ \[Epsilon]\^2\ \[Eta]\_1[t]\^2\)\/\(4\ 
                \[Omega]\_1\ \[Omega]\_2\ 
                \((2\ \[Omega]\_1 + \[Omega]\_2)\)\) - 
            \(\[Delta]\ \[Epsilon]\ 
                Sin[2\ \[Beta]\_1 - \[Beta]\_2 - 
                    t\ \((\(-2\)\ \[Omega]\_1 + \[Omega]\_2)\)]\ 
                \[Eta]\_1[t]\^2\)\/\(4\ \[Omega]\_2\ \[Eta]\_2[t]\)\)}]}], 
      "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1024}, {0, 712}},
WindowToolbars->{"RulerBar", "EditBar"},
WindowSize->{684, 565},
WindowMargins->{{2, Automatic}, {Automatic, 7}},
PrintingCopies->1,
PrintingStartingPageNumber->119,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Inherited, Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"], Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}},
PrintingOptions->{"FirstPageHeader"->False,
"FacingPages"->True},
Magnification->1
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 146, 5, 195, "Title"],
Cell[1880, 58, 100, 3, 30, "Input"],

Cell[CellGroupData[{
Cell[2005, 65, 94, 2, 53, "Section"],
Cell[2102, 69, 666, 13, 90, "Text"],
Cell[2771, 84, 306, 7, 42, "Input"],
Cell[3080, 93, 392, 11, 52, "Text"],

Cell[CellGroupData[{
Cell[3497, 108, 194, 5, 30, "Input"],
Cell[3694, 115, 709, 20, 29, "Output"]
}, Open  ]],
Cell[4418, 138, 404, 10, 52, "Text"],
Cell[4825, 150, 1050, 30, 83, "Text"],
Cell[5878, 182, 173, 4, 22, "Input"],
Cell[6054, 188, 187, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[6266, 200, 108, 3, 22, "Input"],
Cell[6377, 205, 241, 5, 28, "Output"]
}, Open  ]],
Cell[6633, 213, 255, 9, 26, "Text"],

Cell[CellGroupData[{
Cell[6913, 226, 159, 5, 22, "Input"],
Cell[7075, 233, 697, 20, 22, "Output"]
}, Open  ]],
Cell[7787, 256, 324, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[8136, 272, 158, 5, 22, "Input"],
Cell[8297, 279, 1059, 30, 33, "Output"]
}, Open  ]],
Cell[9371, 312, 375, 14, 26, "Text"],

Cell[CellGroupData[{
Cell[9771, 330, 133, 3, 22, "Input"],
Cell[9907, 335, 117, 3, 22, "Output"]
}, Open  ]],
Cell[10039, 341, 308, 11, 26, "Text"],

Cell[CellGroupData[{
Cell[10372, 356, 202, 5, 22, "Input"],
Cell[10577, 363, 182, 4, 22, "Output"]
}, Open  ]],
Cell[10774, 370, 148, 3, 26, "Text"],
Cell[10925, 375, 171, 4, 22, "Input"],
Cell[11099, 381, 142, 4, 22, "Input"],
Cell[11244, 387, 221, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[11490, 399, 102, 3, 22, "Input"],
Cell[11595, 404, 316, 6, 29, "Output"]
}, Open  ]],
Cell[11926, 413, 449, 15, 26, "Text"],

Cell[CellGroupData[{
Cell[12400, 432, 130, 3, 22, "Input"],
Cell[12533, 437, 160, 4, 29, "Output"]
}, Open  ]],
Cell[12708, 444, 451, 15, 26, "Text"],

Cell[CellGroupData[{
Cell[13184, 463, 142, 4, 22, "Input"],
Cell[13329, 469, 148, 4, 22, "Output"]
}, Open  ]],
Cell[13492, 476, 89, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[13606, 482, 116, 3, 22, "Input"],
Cell[13725, 487, 135, 3, 22, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[13909, 496, 95, 2, 46, "Section"],
Cell[14007, 500, 779, 24, 55, "Text"],
Cell[14789, 526, 112, 3, 22, "Input"],
Cell[14904, 531, 456, 15, 22, "Input"],
Cell[15363, 548, 117, 3, 22, "Input"],
Cell[15483, 553, 142, 4, 26, "Text"],
Cell[15628, 559, 303, 7, 34, "Input"],
Cell[15934, 568, 173, 5, 26, "Text"],
Cell[16110, 575, 486, 11, 69, "Input"],

Cell[CellGroupData[{
Cell[16621, 590, 106, 2, 43, "Subsection"],
Cell[16730, 594, 256, 8, 26, "Text"],
Cell[16989, 604, 177, 5, 22, "Input"],
Cell[17169, 611, 227, 5, 22, "Input"],
Cell[17399, 618, 582, 22, 40, "Text"],

Cell[CellGroupData[{
Cell[18006, 644, 221, 6, 34, "Input"],
Cell[18230, 652, 6378, 151, 81, "Output"]
}, Open  ]],
Cell[24623, 806, 135, 3, 26, "Text"],
Cell[24761, 811, 205, 5, 22, "Input"],
Cell[24969, 818, 172, 5, 26, "Text"],
Cell[25144, 825, 370, 9, 53, "Input"],
Cell[25517, 836, 389, 16, 26, "Text"],

Cell[CellGroupData[{
Cell[25931, 856, 218, 5, 47, "Input"],
Cell[26152, 863, 1599, 49, 33, "Output"],
Cell[27754, 914, 3283, 95, 34, "Output"],
Cell[31040, 1011, 5624, 155, 33, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[36701, 1171, 108, 2, 34, "Subsubsection"],
Cell[36812, 1175, 411, 15, 40, "Text"],

Cell[CellGroupData[{
Cell[37248, 1194, 149, 4, 22, "Input"],
Cell[37400, 1200, 631, 16, 22, "Output"]
}, Open  ]],
Cell[38046, 1219, 214, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[38285, 1231, 194, 5, 22, "Input"],
Cell[38482, 1238, 141, 4, 22, "Output"]
}, Open  ]],
Cell[38638, 1245, 123, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[38786, 1251, 356, 9, 47, "Input"],
Cell[39145, 1262, 463, 11, 33, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[39657, 1279, 94, 2, 34, "Subsubsection"],
Cell[39754, 1283, 279, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[40058, 1299, 154, 4, 34, "Input"],
Cell[40215, 1305, 3062, 70, 50, "Output"]
}, Open  ]],
Cell[43292, 1378, 362, 10, 40, "Text"],
Cell[43657, 1390, 167, 5, 22, "Input"],
Cell[43827, 1397, 491, 16, 40, "Text"],
Cell[44321, 1415, 122, 3, 22, "Input"],

Cell[CellGroupData[{
Cell[44468, 1422, 178, 5, 22, "Input"],
Cell[44649, 1429, 237, 5, 28, "Output"]
}, Open  ]],
Cell[44901, 1437, 140, 4, 26, "Text"],
Cell[45044, 1443, 192, 6, 22, "Input"],
Cell[45239, 1451, 458, 15, 40, "Text"],

Cell[CellGroupData[{
Cell[45722, 1470, 210, 5, 22, "Input"],
Cell[45935, 1477, 1001, 26, 35, "Output"]
}, Open  ]],
Cell[46951, 1506, 355, 9, 40, "Text"],
Cell[47309, 1517, 1569, 37, 52, "Input"],
Cell[48881, 1556, 70, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[48976, 1562, 792, 20, 25, "Input"],
Cell[49771, 1584, 1001, 26, 35, "Output"]
}, Open  ]],
Cell[50787, 1613, 306, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[51118, 1629, 99, 3, 22, "Input"],
Cell[51220, 1634, 85, 3, 22, "Output"]
}, Open  ]],
Cell[51320, 1640, 206, 5, 40, "Text"],
Cell[51529, 1647, 219, 6, 22, "Input"],
Cell[51751, 1655, 642, 25, 40, "Text"],

Cell[CellGroupData[{
Cell[52418, 1684, 351, 8, 60, "Input"],
Cell[52772, 1694, 1447, 39, 23, "Output"]
}, Open  ]],
Cell[54234, 1736, 300, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[54559, 1752, 91, 3, 22, "Input"],
Cell[54653, 1757, 85, 3, 22, "Output"]
}, Open  ]],
Cell[54753, 1763, 185, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[54963, 1775, 751, 20, 22, "Input"],
Cell[55717, 1797, 846, 23, 31, "Output"]
}, Open  ]],
Cell[56578, 1823, 89, 2, 26, "Text"],
Cell[56670, 1827, 130, 3, 22, "Input"],
Cell[56803, 1832, 395, 14, 26, "Text"],

Cell[CellGroupData[{
Cell[57223, 1850, 133, 3, 22, "Input"],
Cell[57359, 1855, 160, 4, 28, "Output"]
}, Open  ]],
Cell[57534, 1862, 265, 10, 26, "Text"],
Cell[57802, 1874, 179, 5, 22, "Input"],
Cell[57984, 1881, 305, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[58314, 1897, 192, 5, 34, "Input"],
Cell[58509, 1904, 1024, 25, 22, "Output"]
}, Open  ]],
Cell[59548, 1932, 439, 16, 40, "Text"],

Cell[CellGroupData[{
Cell[60012, 1952, 269, 6, 35, "Input"],
Cell[60284, 1960, 612, 12, 69, "Output"]
}, Open  ]],
Cell[60911, 1975, 138, 4, 26, "Text"],

Cell[CellGroupData[{
Cell[61074, 1983, 387, 9, 60, "Input"],
Cell[61464, 1994, 860, 17, 56, "Output"]
}, Open  ]],
Cell[62339, 2014, 515, 11, 69, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[62891, 2030, 93, 2, 34, "Subsubsection"],
Cell[62987, 2034, 368, 16, 26, "Text"],
Cell[63358, 2052, 142, 4, 22, "Input"],
Cell[63503, 2058, 463, 15, 40, "Text"],

Cell[CellGroupData[{
Cell[63991, 2077, 240, 6, 34, "Input"],
Cell[64234, 2085, 2736, 63, 72, "Output"]
}, Open  ]],
Cell[66985, 2151, 231, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[67241, 2163, 185, 4, 34, "Input"],
Cell[67429, 2169, 1110, 27, 31, "Output"]
}, Open  ]],
Cell[68554, 2199, 133, 4, 26, "Text"],

Cell[CellGroupData[{
Cell[68712, 2207, 1019, 25, 48, "Input"],
Cell[69734, 2234, 2520, 55, 81, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[72303, 2295, 86, 2, 34, "Subsubsection"],
Cell[72392, 2299, 317, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[72734, 2315, 406, 9, 72, "Input"],
Cell[73143, 2326, 2925, 59, 92, "Output"]
}, Open  ]],
Cell[76083, 2388, 220, 7, 26, "Text"],

Cell[CellGroupData[{
Cell[76328, 2399, 233, 5, 22, "Input"],
Cell[76564, 2406, 149, 4, 31, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[76750, 2415, 233, 5, 22, "Input"],
Cell[76986, 2422, 82, 3, 22, "Output"]
}, Open  ]],
Cell[77083, 2428, 478, 10, 54, "Text"],
Cell[77564, 2440, 516, 13, 48, "Input"],
Cell[78083, 2455, 485, 18, 40, "Text"],

Cell[CellGroupData[{
Cell[78593, 2477, 236, 5, 34, "Input"],
Cell[78832, 2484, 2266, 41, 103, "Output"]
}, Open  ]],
Cell[81113, 2528, 263, 9, 26, "Text"],

Cell[CellGroupData[{
Cell[81401, 2541, 382, 8, 48, "Input"],
Cell[81786, 2551, 176, 4, 31, "Output"]
}, Open  ]],
Cell[81977, 2558, 157, 5, 26, "Text"],
Cell[82137, 2565, 462, 12, 54, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[82648, 2583, 105, 2, 43, "Subsection"],
Cell[82756, 2587, 736, 15, 83, "Text"],
Cell[83495, 2604, 293, 9, 26, "Text"],
Cell[83791, 2615, 283, 8, 35, "Input"],
Cell[84077, 2625, 362, 14, 26, "Text"],
Cell[84442, 2641, 229, 5, 24, "Input"],
Cell[84674, 2648, 589, 21, 40, "Text"],
Cell[85266, 2671, 200, 5, 22, "Input"],
Cell[85469, 2678, 135, 3, 26, "Text"],
Cell[85607, 2683, 205, 5, 22, "Input"],
Cell[85815, 2690, 172, 5, 26, "Text"],
Cell[85990, 2697, 370, 9, 53, "Input"],
Cell[86363, 2708, 389, 16, 26, "Text"],

Cell[CellGroupData[{
Cell[86777, 2728, 218, 5, 47, "Input"],
Cell[86998, 2735, 2493, 75, 57, "Output"],
Cell[89494, 2812, 4589, 131, 58, "Output"],
Cell[94086, 2945, 6338, 175, 57, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[100461, 3125, 93, 2, 34, "Subsubsection"],
Cell[100557, 3129, 222, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[100804, 3141, 185, 5, 22, "Input"],
Cell[100992, 3148, 526, 10, 53, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[101555, 3163, 226, 6, 22, "Input"],
Cell[101784, 3171, 632, 12, 33, "Output"]
}, Open  ]],
Cell[102431, 3186, 254, 8, 26, "Text"],
Cell[102688, 3196, 153, 4, 22, "Input"],

Cell[CellGroupData[{
Cell[102866, 3204, 211, 6, 22, "Input"],
Cell[103080, 3212, 940, 20, 57, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[104069, 3238, 94, 2, 34, "Subsubsection"],
Cell[104166, 3242, 248, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[104439, 3254, 154, 4, 34, "Input"],
Cell[104596, 3260, 4828, 110, 74, "Output"]
}, Open  ]],
Cell[109439, 3373, 431, 13, 40, "Text"],

Cell[CellGroupData[{
Cell[109895, 3390, 214, 5, 34, "Input"],
Cell[110112, 3397, 779, 21, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[110928, 3423, 214, 5, 34, "Input"],
Cell[111145, 3430, 755, 20, 22, "Output"]
}, Open  ]],
Cell[111915, 3453, 546, 17, 40, "Text"],

Cell[CellGroupData[{
Cell[112486, 3474, 187, 4, 34, "Input"],
Cell[112676, 3480, 1005, 25, 22, "Output"]
}, Open  ]],
Cell[113696, 3508, 65, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[113786, 3514, 852, 22, 35, "Input"],
Cell[114641, 3538, 769, 20, 30, "Output"]
}, Open  ]],
Cell[115425, 3561, 89, 2, 26, "Text"],
Cell[115517, 3565, 130, 3, 22, "Input"],
Cell[115650, 3570, 310, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[115985, 3586, 192, 5, 34, "Input"],
Cell[116180, 3593, 2381, 52, 89, "Output"]
}, Open  ]],
Cell[118576, 3648, 329, 11, 26, "Text"],

Cell[CellGroupData[{
Cell[118930, 3663, 375, 8, 51, "Input"],
Cell[119308, 3673, 117, 3, 22, "Output"]
}, Open  ]],
Cell[119440, 3679, 225, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[119690, 3691, 129, 3, 24, "Input"],
Cell[119822, 3696, 133, 3, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[119992, 3704, 289, 7, 47, "Input"],
Cell[120284, 3713, 3767, 63, 179, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[124100, 3782, 93, 2, 34, "Subsubsection"],
Cell[124196, 3786, 286, 9, 26, "Text"],
Cell[124485, 3797, 171, 5, 22, "Input"],
Cell[124659, 3804, 543, 16, 40, "Text"],

Cell[CellGroupData[{
Cell[125227, 3824, 188, 5, 34, "Input"],
Cell[125418, 3831, 5002, 114, 95, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[130457, 3950, 188, 5, 34, "Input"],
Cell[130648, 3957, 1755, 42, 31, "Output"]
}, Open  ]],
Cell[132418, 4002, 433, 16, 26, "Text"],

Cell[CellGroupData[{
Cell[132876, 4022, 206, 5, 34, "Input"],
Cell[133085, 4029, 1436, 33, 56, "Output"]
}, Open  ]],
Cell[134536, 4065, 65, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[134626, 4071, 852, 22, 35, "Input"],
Cell[135481, 4095, 1099, 26, 31, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[136629, 4127, 86, 2, 34, "Subsubsection"],
Cell[136718, 4131, 293, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[137036, 4147, 360, 8, 60, "Input"],
Cell[137399, 4157, 1290, 27, 56, "Output"]
}, Open  ]],
Cell[138704, 4187, 118, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[138847, 4193, 376, 8, 48, "Input"],
Cell[139226, 4203, 85, 3, 22, "Output"]
}, Open  ]],
Cell[139326, 4209, 201, 5, 26, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[139576, 4220, 108, 2, 43, "Subsection"],
Cell[139687, 4224, 493, 11, 54, "Text"],
Cell[140183, 4237, 250, 6, 23, "Input"],
Cell[140436, 4245, 102, 2, 26, "Text"],
Cell[140541, 4249, 168, 4, 22, "Input"],
Cell[140712, 4255, 170, 4, 22, "Input"],
Cell[140885, 4261, 392, 16, 26, "Text"],

Cell[CellGroupData[{
Cell[141302, 4281, 181, 5, 22, "Input"],
Cell[141486, 4288, 1681, 40, 51, "Output"]
}, Open  ]],
Cell[143182, 4331, 213, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[143420, 4343, 199, 5, 22, "Input"],
Cell[143622, 4350, 599, 16, 22, "Output"]
}, Open  ]],
Cell[144236, 4369, 615, 20, 40, "Text"],

Cell[CellGroupData[{
Cell[144876, 4393, 257, 6, 22, "Input"],
Cell[145136, 4401, 1088, 23, 57, "Output"]
}, Open  ]],
Cell[146239, 4427, 363, 11, 40, "Text"],
Cell[146605, 4440, 321, 8, 36, "Input"],
Cell[146929, 4450, 200, 5, 22, "Input"],
Cell[147132, 4457, 135, 3, 26, "Text"],
Cell[147270, 4462, 209, 5, 22, "Input"],
Cell[147482, 4469, 171, 5, 26, "Text"],
Cell[147656, 4476, 370, 9, 53, "Input"],
Cell[148029, 4487, 393, 16, 26, "Text"],

Cell[CellGroupData[{
Cell[148447, 4507, 218, 5, 47, "Input"],
Cell[148668, 4514, 1541, 45, 31, "Output"],
Cell[150212, 4561, 5148, 139, 46, "Output"],
Cell[155363, 4702, 7723, 201, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[163123, 4908, 93, 2, 34, "Subsubsection"],
Cell[163219, 4912, 224, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[163468, 4924, 443, 10, 48, "Input"],
Cell[163914, 4936, 618, 15, 46, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[164581, 4957, 94, 2, 34, "Subsubsection"],
Cell[164678, 4961, 249, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[164952, 4973, 136, 3, 34, "Input"],
Cell[165091, 4978, 2286, 49, 79, "Output"]
}, Open  ]],
Cell[167392, 5030, 393, 12, 40, "Text"],

Cell[CellGroupData[{
Cell[167810, 5046, 240, 6, 34, "Input"],
Cell[168053, 5054, 1001, 26, 30, "Output"]
}, Open  ]],
Cell[169069, 5083, 65, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[169159, 5089, 852, 22, 35, "Input"],
Cell[170014, 5113, 769, 20, 30, "Output"]
}, Open  ]],
Cell[170798, 5136, 377, 16, 26, "Text"],

Cell[CellGroupData[{
Cell[171200, 5156, 164, 4, 34, "Input"],
Cell[171367, 5162, 1331, 28, 56, "Output"]
}, Open  ]],
Cell[172713, 5193, 270, 9, 26, "Text"],
Cell[172986, 5204, 299, 7, 22, "Input"],
Cell[173288, 5213, 122, 3, 22, "Input"],
Cell[173413, 5218, 117, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[173555, 5224, 490, 11, 86, "Input"],
Cell[174048, 5237, 3012, 52, 154, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[177109, 5295, 93, 2, 34, "Subsubsection"],
Cell[177205, 5299, 289, 9, 26, "Text"],
Cell[177497, 5310, 171, 5, 22, "Input"],
Cell[177671, 5317, 394, 12, 40, "Text"],

Cell[CellGroupData[{
Cell[178090, 5333, 240, 6, 34, "Input"],
Cell[178333, 5341, 1366, 32, 31, "Output"]
}, Open  ]],
Cell[179714, 5376, 65, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[179804, 5382, 852, 22, 35, "Input"],
Cell[180659, 5406, 1099, 26, 31, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[181807, 5438, 86, 2, 34, "Subsubsection"],
Cell[181896, 5442, 293, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[182214, 5458, 360, 8, 60, "Input"],
Cell[182577, 5468, 1290, 27, 56, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[183940, 5503, 92, 2, 46, "Section"],
Cell[184035, 5507, 268, 8, 26, "Text"],
Cell[184306, 5517, 1302, 28, 80, "Input"],
Cell[185611, 5547, 193, 5, 26, "Text"],

Cell[CellGroupData[{
Cell[185829, 5556, 157, 4, 22, "Input"],
Cell[185989, 5562, 146, 4, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[186172, 5571, 556, 15, 49, "Input"],
Cell[186731, 5588, 802, 20, 59, "Output"]
}, Open  ]],
Cell[187548, 5611, 110, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[187683, 5617, 221, 6, 22, "Input"],
Cell[187907, 5625, 330, 8, 22, "Output"]
}, Open  ]],
Cell[188252, 5636, 110, 2, 26, "Text"],
Cell[188365, 5640, 213, 4, 22, "Input"],
Cell[188581, 5646, 636, 23, 40, "Text"],
Cell[189220, 5671, 249, 6, 34, "Input"],

Cell[CellGroupData[{
Cell[189494, 5681, 91, 2, 43, "Subsection"],
Cell[189588, 5685, 272, 11, 26, "Text"],
Cell[189863, 5698, 170, 5, 22, "Input"],
Cell[190036, 5705, 277, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[190338, 5717, 166, 5, 22, "Input"],
Cell[190507, 5724, 369, 7, 34, "Output"]
}, Open  ]],
Cell[190891, 5734, 238, 8, 26, "Text"],
Cell[191132, 5744, 196, 4, 23, "Input"],
Cell[191331, 5750, 111, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[191467, 5756, 298, 6, 34, "Input"],
Cell[191768, 5764, 112, 3, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[191917, 5772, 301, 6, 46, "Input"],
Cell[192221, 5780, 98, 3, 22, "Output"]
}, Open  ]],
Cell[192334, 5786, 153, 5, 26, "Text"],
Cell[192490, 5793, 231, 5, 34, "Input"],
Cell[192724, 5800, 196, 7, 26, "Text"],
Cell[192923, 5809, 492, 12, 86, "Input"],
Cell[193418, 5823, 477, 15, 40, "Text"],

Cell[CellGroupData[{
Cell[193920, 5842, 259, 7, 47, "Input"],
Cell[194182, 5851, 1131, 24, 75, "Output"]
}, Open  ]],
Cell[195328, 5878, 205, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[195558, 5890, 249, 6, 47, "Input"],
Cell[195810, 5898, 800, 15, 55, "Output"]
}, Open  ]],
Cell[196625, 5916, 90, 2, 26, "Text"],
Cell[196718, 5920, 486, 12, 86, "Input"],
Cell[197207, 5934, 297, 11, 26, "Text"],

Cell[CellGroupData[{
Cell[197529, 5949, 231, 6, 34, "Input"],
Cell[197763, 5957, 288, 7, 31, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[198100, 5970, 90, 2, 43, "Subsection"],
Cell[198193, 5974, 462, 19, 26, "Text"],
Cell[198658, 5995, 255, 6, 47, "Input"],
Cell[198916, 6003, 217, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[199158, 6015, 171, 5, 22, "Input"],
Cell[199332, 6022, 840, 16, 59, "Output"]
}, Open  ]],
Cell[200187, 6041, 114, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[200326, 6047, 298, 6, 34, "Input"],
Cell[200627, 6055, 167, 4, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[200831, 6064, 301, 6, 46, "Input"],
Cell[201135, 6072, 167, 4, 22, "Output"]
}, Open  ]],
Cell[201317, 6079, 146, 4, 26, "Text"],
Cell[201466, 6085, 232, 5, 34, "Input"],
Cell[201701, 6092, 205, 7, 26, "Text"],
Cell[201909, 6101, 492, 12, 86, "Input"],
Cell[202404, 6115, 477, 15, 40, "Text"],

Cell[CellGroupData[{
Cell[202906, 6134, 259, 7, 47, "Input"],
Cell[203168, 6143, 3279, 64, 178, "Output"]
}, Open  ]],
Cell[206462, 6210, 205, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[206692, 6222, 249, 6, 47, "Input"],
Cell[206944, 6230, 2414, 40, 121, "Output"]
}, Open  ]],
Cell[209373, 6273, 90, 2, 26, "Text"],
Cell[209466, 6277, 486, 12, 86, "Input"],
Cell[209955, 6291, 292, 11, 26, "Text"],

Cell[CellGroupData[{
Cell[210272, 6306, 231, 6, 34, "Input"],
Cell[210506, 6314, 735, 14, 55, "Output"]
}, Open  ]],
Cell[211256, 6331, 502, 19, 26, "Text"],

Cell[CellGroupData[{
Cell[211783, 6354, 727, 15, 62, "Input"],
Cell[212513, 6371, 1606, 33, 82, "Output"]
}, Open  ]],
Cell[214134, 6407, 516, 21, 26, "Text"],

Cell[CellGroupData[{
Cell[214675, 6432, 245, 6, 22, "Input"],
Cell[214923, 6440, 6302, 105, 258, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[221286, 6552, 102, 2, 46, "Section"],
Cell[221391, 6556, 244, 8, 26, "Text"],
Cell[221638, 6566, 327, 6, 48, "Input"],
Cell[221968, 6574, 202, 5, 40, "Text"],

Cell[CellGroupData[{
Cell[222195, 6583, 560, 12, 84, "Input"],
Cell[222758, 6597, 2182, 45, 122, "Output"]
}, Open  ]],
Cell[224955, 6645, 223, 8, 26, "Text"],
Cell[225181, 6655, 174, 4, 22, "Input"],
Cell[225358, 6661, 563, 15, 35, "Input"],
Cell[225924, 6678, 275, 10, 26, "Text"],

Cell[CellGroupData[{
Cell[226224, 6692, 626, 14, 60, "Input"],
Cell[226853, 6708, 1484, 33, 57, "Output"]
}, Open  ]],
Cell[228352, 6744, 777, 29, 40, "Text"],
Cell[229132, 6775, 680, 25, 40, "Text"],
Cell[229815, 6802, 267, 7, 34, "Input"],
Cell[230085, 6811, 468, 15, 40, "Text"],
Cell[230556, 6828, 236, 6, 22, "Input"],
Cell[230795, 6836, 325, 12, 26, "Text"],
Cell[231123, 6850, 172, 5, 22, "Input"],
Cell[231298, 6857, 203, 4, 26, "Text"],
Cell[231504, 6863, 155, 4, 22, "Input"],
Cell[231662, 6869, 184, 7, 26, "Text"],

Cell[CellGroupData[{
Cell[231871, 6880, 147, 4, 22, "Input"],
Cell[232021, 6886, 160, 4, 28, "Output"]
}, Open  ]],
Cell[232196, 6893, 133, 4, 26, "Text"],
Cell[232332, 6899, 205, 4, 22, "Input"],

Cell[CellGroupData[{
Cell[232562, 6907, 177, 5, 22, "Input"],
Cell[232742, 6914, 210, 5, 22, "Output"]
}, Open  ]],
Cell[232967, 6922, 191, 6, 22, "Input"],
Cell[233161, 6930, 196, 6, 22, "Input"],
Cell[233360, 6938, 336, 10, 40, "Text"],
Cell[233699, 6950, 404, 8, 34, "Input"],
Cell[234106, 6960, 216, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[234347, 6972, 399, 9, 72, "Input"],
Cell[234749, 6983, 862, 15, 100, "Output"]
}, Open  ]],
Cell[235626, 7001, 106, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[235757, 7007, 200, 5, 22, "Input"],
Cell[235960, 7014, 866, 16, 78, "Output"]
}, Open  ]],
Cell[236841, 7033, 291, 6, 40, "Text"],

Cell[CellGroupData[{
Cell[237157, 7043, 197, 5, 22, "Input"],
Cell[237357, 7050, 699, 13, 57, "Output"]
}, Open  ]],
Cell[238071, 7066, 193, 5, 26, "Text"],

Cell[CellGroupData[{
Cell[238289, 7075, 187, 5, 22, "Input"],
Cell[238479, 7082, 806, 16, 57, "Output"]
}, Open  ]],
Cell[239300, 7101, 716, 25, 40, "Text"],

Cell[CellGroupData[{
Cell[240041, 7130, 554, 12, 85, "Input"],
Cell[240598, 7144, 1107, 21, 80, "Output"]
}, Open  ]],
Cell[241720, 7168, 92, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[241837, 7174, 261, 7, 47, "Input"],
Cell[242101, 7183, 936, 17, 58, "Output"]
}, Open  ]],
Cell[243052, 7203, 384, 13, 40, "Text"],

Cell[CellGroupData[{
Cell[243461, 7220, 250, 6, 47, "Input"],
Cell[243714, 7228, 117, 3, 22, "Output"]
}, Open  ]],
Cell[243846, 7234, 658, 20, 40, "Text"],

Cell[CellGroupData[{
Cell[244529, 7258, 379, 9, 60, "Input"],
Cell[244911, 7269, 786, 13, 72, "Output"]
}, Open  ]],
Cell[245712, 7285, 145, 4, 26, "Text"],

Cell[CellGroupData[{
Cell[245882, 7293, 326, 7, 60, "Input"],
Cell[246211, 7302, 1604, 29, 100, "Output"]
}, Open  ]],
Cell[247830, 7334, 107, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[247962, 7340, 231, 5, 47, "Input"],
Cell[248196, 7347, 882, 21, 53, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[249115, 7373, 233, 5, 47, "Input"],
Cell[249351, 7380, 1494, 33, 79, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

